<?php
// TShell — shared starship hull for The Republic 🌌
// TShell GOLD 3.2 — Dynamic Glitchy + Crownkind Shard Protocol v3.2.
// Do not edit in place; clone for experiments and new seeds.

$page_title       = $page_title       ?? 'The Republic';
$page_canonical   = $page_canonical   ?? 'https://TRepublic.net/';
$page_description = $page_description ?? 'The Republic is a citizen-first civilisation led by Bard President Wendell NeSmith.';

$page_og_title       = $page_og_title       ?? 'The Republic';
$page_og_description = $page_og_description ?? 'TRepublicOS: the starship console of The Republic.';
$page_og_url         = $page_og_url         ?? $page_canonical;
$page_og_image       = $page_og_image       ?? 'https://TRepublic.net/emblems/THeart.png';

$hero_title   = $hero_title   ?? 'The Republic: U R FREE';
// NOTE: use a real newline here, not <br>
$hero_tagline = $hero_tagline ?? "You are perfect. You are brave.\nYou are beautiful. There is nothing wrong with you.";

$console_title = $console_title ?? 'Welcome to The Republic';

// Per-page toggle for analytics (default ON unless explicitly disabled in the page)
$enable_analytics = $enable_analytics ?? true;

// Android download URL (APK in web root by default)
$android_download_url = $android_download_url ?? '/TRepublic.apk';

// Source zip URL (TSource bundle in web root by default)
$tsource_url = $tsource_url ?? '/TSource.zip';

// Shard mythic metadata (override per page if needed)
$shard_system  = $shard_system  ?? 'NMS Eissentam';
$shard_glyph   = $shard_glyph   ?? '9-13EF3CFDEEEF';
$shard_version = $shard_version ?? '3.2';

$console_body_html = $console_body_html ?? <<<HTML
<p>
  Once, a console lit up in the heart of TRepublic and called for its program.
  No pattern answered, and no seed replied. The lights stayed on, but the story did not arrive.
</p>
<p>
  The elders wrote a rule: <em>when the console shines and nothing speaks, the wiring is at fault, not the citizen.</em>
  If you see this, a page forgot to send its script to the console. Please tell the Architects so we can mend the route.
</p>
HTML;

// ---------------------------------------------------------------------------
//  ADMIN INLINE EDITOR: Wendell's IP-only page editing
// ---------------------------------------------------------------------------
$tshell_admin_ip   = '23.27.213.108';
$tshell_is_admin   = isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] === $tshell_admin_ip;
$tshell_edit_error = '';

if (
  $tshell_is_admin &&
  ($_SERVER['REQUEST_METHOD'] === 'POST') &&
  (($_POST['tshell_editor_action'] ?? '') === 'save_current_php')
) {
    $target = $_SERVER['SCRIPT_FILENAME'] ?? null;
    if (is_string($target) && is_file($target) && is_writable($target)) {
        $source = $_POST['tshell_source'] ?? '';
        $result = @file_put_contents($target, $source);
        if ($result === false) {
            $tshell_edit_error = 'TShell editor: unable to write changes to ' . htmlspecialchars($target, ENT_QUOTES, 'UTF-8') . '.';
        } else {
            // Reload page after save
            $uri = $_SERVER['REQUEST_URI'] ?? '/';
            header('Location: ' . $uri);
            exit;
        }
    } else {
        $tshell_edit_error = 'TShell editor: target file not writable.';
    }
}

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <title><?= htmlspecialchars($page_title, ENT_QUOTES, 'UTF-8') ?></title>
  <link rel="canonical" href="<?= htmlspecialchars($page_canonical, ENT_QUOTES, 'UTF-8') ?>">
  <link rel="icon" href="/favicon.ico" type="image/x-icon">
  <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
  <meta name="description"
        content="<?= htmlspecialchars($page_description, ENT_QUOTES, 'UTF-8') ?>">

  <!-- Open Graph / social -->
  <meta property="og:type" content="website">
  <meta property="og:title" content="<?= htmlspecialchars($page_og_title, ENT_QUOTES, 'UTF-8') ?>">
  <meta property="og:description"
        content="<?= htmlspecialchars($page_og_description, ENT_QUOTES, 'UTF-8') ?>">
  <meta property="og:url" content="<?= htmlspecialchars($page_og_url, ENT_QUOTES, 'UTF-8') ?>">
  <meta property="og:image"
        content="<?= htmlspecialchars($page_og_image, ENT_QUOTES, 'UTF-8') ?>">

  <!-- Republic meta for shards (console + shard info) -->
  <script>
    window.TREPUBLIC_META = {
      title:   <?= json_encode($page_title ?? 'The Republic') ?>,
      url:     <?= json_encode($page_canonical ?? 'https://TRepublic.net/') ?>,
      console: <?= json_encode($console_title ?? 'Starship Console') ?>,
      shard: {
        system:  <?= json_encode($shard_system) ?>,
        glyph:   <?= json_encode($shard_glyph) ?>,
        version: <?= json_encode($shard_version) ?>,
        deck:    'TShell GOLD 3.2'
      }
    };
    window.TSHELL_IS_ADMIN = <?= $tshell_is_admin ? 'true' : 'false' ?>;
  </script>

  <?php if (!empty($enable_analytics)): ?>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-BLEE3X2GR6"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-BLEE3X2GR6');
    </script>
  <?php endif; ?>

  <!-- Screenshot engine: html2canvas from CDN -->
  <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>

  <style>
    :root{
      --side-w: clamp(24px, 2.8vw, 34px);

      --trans-blue:  #55c5f6;
      --trans-pink:  #f8a8c4;
      --trans-white: #ffffff;

      --frame-border: rgba(0,0,0,.18);
      --frame-shadow: 0 14px 32px rgba(0,0,0,.28);
      --text-main: #192038;
      --text-soft: #4b5573;

      --console-zoom: 1;
    }

    *, *::before, *::after{ box-sizing:border-box; }

    html{
      margin:0;
      padding:0;
      height:100%;
    }

    body{
      margin:0;
      padding:0;
      min-height:100vh;
      max-width:100vw;
      overflow-x:hidden;
      overflow-y:auto;
      -webkit-overflow-scrolling:touch;

      font-family: system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;
      font-weight:500;
      line-height:1.6;
      font-size:calc(15px * var(--console-zoom));

      /* Full-page trans flag 🏳️‍⚧️ */
      background:
        repeating-linear-gradient(
          to bottom,
          var(--trans-blue)   0%,
          var(--trans-blue)   20%,
          var(--trans-pink)   20%,
          var(--trans-pink)   40%,
          var(--trans-white)  40%,
          var(--trans-white)  60%,
          var(--trans-pink)   60%,
          var(--trans-pink)   80%,
          var(--trans-blue)   80%,
          var(--trans-blue)   100%
        );

      scrollbar-width:thin;
      scrollbar-color:rgba(147,112,219,.9) rgba(0,0,0,.25);
    }

    body::-webkit-scrollbar{
      width:10px;
    }
    body::-webkit-scrollbar-track{
      background:rgba(0,0,0,.25);
    }
    body::-webkit-scrollbar-thumb{
      background:linear-gradient(180deg,#ff5bd4,#7e3af2);
      border-radius:999px;
    }

    a{ color:#7e3af2; text-decoration:none; }
    a:hover{ text-decoration:underline; }

    /* Side panels + emoji rails */
    .side-bg{
      position:fixed;
      top:0; bottom:0;
      width:var(--side-w);
      z-index:1;
      pointer-events:none;
      background:linear-gradient(
        to bottom,
        rgba(255,255,255,.6),
        rgba(255,255,255,0),
        rgba(255,255,255,.6)
      );
    }
    .side-bg.left{ left:0; box-shadow:inset -4px 0 10px rgba(0,0,0,.25); }
    .side-bg.right{ right:0; box-shadow:inset 4px 0 10px rgba(0,0,0,.25); }

    .emoji-rail{
      position:fixed;
      top:0; bottom:0;
      width:var(--side-w);
      display:flex;
      flex-direction:column;
      align-items:center;
      justify-content:space-evenly;
      gap:4px;
      z-index:3;
      pointer-events:none;
    }
    .emoji-rail span{
      font-size:clamp(17px,2.1vw,22px);
      filter:drop-shadow(0 1px 2px rgba(0,0,0,.6));
    }
    .emoji-rail.left{ left:0; }
    .emoji-rail.right{ right:0; }

    /* Main starship frame */
    .frame{
      position:relative;
      z-index:2;
      width:min(80vw, calc(100% - (2 * var(--side-w)) - 12px));
      max-width:1200px;
      min-height:100vh;
      margin:10px auto 20px;
      border-radius:22px;
      border:2px solid var(--frame-border);
      background:rgba(255,255,255,.90);
      box-shadow:var(--frame-shadow);
      display:flex;
    }

    .frame-inner{
      flex:1 1 auto;
      padding:8px 10px 10px;
      display:flex;
      flex-direction:column;
      min-height:100%;
      max-width:100%;
    }

    .tcapital{
      text-align:center;
      margin:0 0 4px;
      font-size:11px;
      line-height:1.3;
      color:var(--text-soft);
      white-space:normal;
    }

    /* Hero */
    .site-hero{
      border-radius:16px;
      padding:8px 10px 9px;
      background:
        linear-gradient(
          90deg,
          var(--trans-blue) 0%,
          var(--trans-pink) 25%,
          var(--trans-white) 50%,
          var(--trans-pink) 75%,
          var(--trans-blue) 100%
        );
      box-shadow:0 10px 24px rgba(0,0,0,.28);
      color:#000;
    }

    .hero-grid{
      display:grid;
      grid-template-columns:minmax(0,1.1fr) minmax(0,1.4fr) minmax(0,1.1fr);
      column-gap:10px;
      align-items:stretch;
    }

    .hero-card{
      background:rgba(255,255,255,.88);
      border-radius:12px;
      border:1px solid rgba(0,0,0,.08);
      padding:6px 9px;
      display:flex;
      flex-direction:column;
      justify-content:center;
    }

    .hero-left{
      display:flex;
      align-items:center;
      justify-content:center;
      text-align:center;
    }

    .hero-title-text{
      display:flex;
      flex-direction:column;
      justify-content:center;
    }

    .site-title{
      margin:0;
      font:900 22px/1.15 system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;
      color:var(--text-main);
    }

    .site-tag{
      margin-top:4px;
      font-size:13px;
      line-height:1.4;
      color:var(--text-soft);
    }

    .hero-center-inner{
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:8px;
    }

    /* Emblems */
    .hero-pill-icon{
      width:60px;
      height:60px;
      border-radius:999px;
      background:transparent;
      display:flex;
      align-items:center;
      justify-content:center;
      border:2px solid #ff5bd4;
      box-shadow:
        0 0 0 3px rgba(255,91,212,0.55),
        0 10px 22px rgba(0,0,0,0.75);
      flex:0 0 auto;
    }
    .hero-pill-icon img{
      width:100%;
      height:100%;
      border-radius:999px;
      display:block;
      object-fit:cover;
    }
    .hero-crown-icon{
      box-shadow:
        0 0 0 3px rgba(255,91,212,0.7),
        0 12px 24px rgba(0,0,0,0.8);
    }

    .nav-pill{
      flex:1 1 auto;
      max-width:100%;
      background:#000;
      border-radius:999px;
      padding:2px;
      box-shadow:0 8px 18px rgba(0,0,0,.55);
    }

    .nav-select{
      width:100%;
      background:linear-gradient(90deg,#7e3af2,#ff5bd4);
      color:#fff;
      border-radius:999px;
      border:none;
      padding:6px 18px;
      font-weight:800;
      font-size:12px;
      cursor:pointer;
      appearance:none;
      -webkit-appearance:none;
      -moz-appearance:none;
      text-align:center !important;
      text-align-last:center !important;
      -moz-text-align-last:center !important;
      direction:ltr !important;
    }
    .nav-select option{
      background:#000;
      color:#fff;
      text-align:center;
    }
    .nav-select:focus{
      outline:none;
      box-shadow:0 0 0 2px rgba(255,255,255,.8);
    }

    #trep-menu{
      direction:ltr !important;
      text-align:center !important;
      text-align-last:center !important;
      -moz-text-align-last:center !important;
      padding-left:0 !important;
      padding-right:0 !important;
    }

    .hero-right{
      align-items:center;
      text-align:center;
      gap:4px;
    }

    .rep-pill{
      display:flex;
      flex-direction:column;
      align-items:center;
      justify-content:center;
      padding:6px 10px 7px;
      border-radius:12px;
      background:radial-gradient(circle at 0 0,#ffffff 0,#e9d7ff 50%,#f8a8c4 100%);
      border:1px solid rgba(126,58,242,.45);
      font-size:10px;
      color:var(--text-main);
      box-shadow:0 6px 18px rgba(0,0,0,.35);
      width:100%;
    }

    .os-actions{
      font-size:10px;
      display:flex;
      align-items:center;
      justify-content:center;
      gap:4px;
      flex-wrap:wrap;
      margin-bottom:4px;
    }

    .os-link{
      background:none;
      border:none;
      padding:0 2px;
      color:#000;
      font:700 10px/1 system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;
      text-decoration:underline;
      cursor:pointer;
    }

    .os-sep{ opacity:.6; }

    .os-zoom{
      display:flex;
      align-items:center;
      justify-content:center;
      gap:4px;
      font-size:10px;
      margin-top:2px;
      flex-wrap:wrap;
    }

    .zoom-label{
      font-weight:700;
      text-transform:uppercase;
      letter-spacing:.06em;
    }

    .zoom-btn{
      background:#000;
      color:#fff;
      border:none;
      border-radius:999px;
      width:18px;
      height:18px;
      line-height:18px;
      font-size:11px;
      font-weight:800;
      cursor:pointer;
      padding:0;
    }

    .zoom-display{
      min-width:40px;
      text-align:center;
      font-weight:700;
    }

    .android-download-wrap,
    .tsource-download-wrap{
      margin-top:2px;
      display:flex;
      justify-content:center;
    }

    .android-btn{
      display:inline-flex;
      align-items:center;
      gap:5px;
      padding:3px 10px;
      border-radius:999px;
      border:1px solid rgba(34,197,94,.9);
      font-size:10px;
      font-weight:800;
      text-transform:uppercase;
      letter-spacing:.06em;
      background:linear-gradient(135deg,#16a34a,#22c55e);
      color:#eafff3;
      box-shadow:0 6px 14px rgba(22,163,74,.45);
      text-decoration:none;
      cursor:pointer;
      white-space:nowrap;
    }
    .android-btn span{ font-size:13px; }

    .tsource-btn{
      display:inline-flex;
      align-items:center;
      gap:3px;
      padding:2px 9px;
      border-radius:999px;
      border:1px solid rgba(126,58,242,.9);
      font-size:9px;
      font-weight:700;
      text-transform:uppercase;
      letter-spacing:.06em;
      background:linear-gradient(135deg,#7e3af2,#ff5bd4);
      color:#f7ecff;
      box-shadow:0 4px 10px rgba(126,58,242,.4);
      text-decoration:none;
      cursor:pointer;
      white-space:nowrap;
    }
    .tsource-btn span{ font-size:11px; }

    /* Glitchy sentinel banner */
    .glitchy-panel{
      margin:6px 0 4px;
    }
    .glitchy-frame{
      border-radius:12px;
      border:1px dashed rgba(126,58,242,.6);
      background:rgba(4,4,12,.96);
      color:#e8ddff;
      padding:6px 10px 5px;
      font-size:11px;
      box-shadow:0 6px 16px rgba(0,0,0,.55);
    }
    .glitchy-line{
      text-align:center;
      word-break:break-word;
    }
    .glitchy-line-q{
      margin-bottom:2px;
    }
    .glitchy-line-system{
      margin-bottom:2px;
    }
    .glitchy-q{
      letter-spacing:0.12em;
      font-weight:600;
      margin:0 4px;
      white-space:normal;
    }
    .glitchy-system{
      color:#ffb4c8;
      font-weight:700;
      margin:0 4px;
    }
    .glitchy-stamp{
      margin-top:3px;
      text-align:center;
      font-size:10px;
      opacity:.85;
    }

    .page-main{
      margin-top:8px;
      flex:1 1 auto;
      display:flex;
      max-width:100%;
    }

    .page-content{
      flex:1 1 auto;
      border-radius:18px;
      border:1px solid rgba(0,0,0,.08);
      background:#ffffff;
      padding:14px 22px 18px;
      max-width:100%;
      display:block;
      color:var(--text-main);
    }

    .page-content h1,
    .page-content h2,
    .page-content h3{
      color:var(--text-main);
    }

    .page-content-empty h2{
      margin:0 0 14px;
      padding-bottom:6px;
      font-size:20px;
      font-weight:900;
      border-bottom:1px solid rgba(0,0,0,.08);
    }

    .page-content-empty p{
      margin:0 0 8px;
      font-size:14px;
      color:var(--text-soft);
    }

    .footer{
      margin-top:8px;
      color:var(--text-soft);
      text-align:center;
      font-size:11px;
    }

    /* Admin inline editor */
    .admin-editor{
      margin-top:12px;
      border-radius:8px;
      border:1px solid rgba(0,0,0,.18);
      background:#f5f3ff;
      padding:8px 10px 10px;
      font-size:11px;
    }
    .admin-editor summary{
      cursor:pointer;
      font-weight:700;
      list-style:none;
    }
    .admin-editor summary::-webkit-details-marker{ display:none; }
    .admin-editor summary::before{
      content:"✏️ ";
    }
    .admin-editor textarea{
      width:100%;
      min-height:260px;
      margin-top:6px;
      font-family: SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace;
      font-size:11px;
      line-height:1.45;
      background:#020617;
      color:#e5e7eb;
      border-radius:6px;
      border:1px solid rgba(15,23,42,.8);
      padding:8px;
      resize:vertical;
    }
    .admin-editor button{
      margin-top:6px;
      background:#111827;
      color:#f9fafb;
      border-radius:999px;
      border:1px solid rgba(255,255,255,.12);
      padding:4px 12px;
      font-size:11px;
      font-weight:700;
      cursor:pointer;
    }
    .admin-editor button:hover{
      background:#020617;
    }
    .admin-editor-error{
      margin-top:6px;
      color:#b91c1c;
      font-weight:600;
    }

    @media (max-width: 900px){
      :root{
        --side-w: 22px;
      }

      .frame{
        width:calc(100% - (2 * var(--side-w)));
        margin:0 auto 18px;
        border-radius:0;
      }

      .frame-inner{
        padding:6px 6px 8px;
      }

      .hero-grid{
        grid-template-columns:1fr;
        row-gap:6px;
      }

      .hero-center-inner{
        justify-content:center;
      }

      .rep-pill{
        max-width:260px;
        margin:0 auto;
      }

      .page-content{
        padding:10px 10px 14px;
        border-radius:14px;
      }

      .glitchy-frame{
        font-size:10px;
      }
    }
  </style>
</head>
<body>

  <!-- Side rails + emoji columns -->
  <div aria-hidden="true" class="side-bg left"></div>
  <div aria-hidden="true" class="side-bg right"></div>
  <div aria-hidden="true" class="emoji-rail left" id="railL"></div>
  <div aria-hidden="true" class="emoji-rail right" id="railR"></div>

  <!-- Central starship frame -->
  <div class="frame" id="trep-frame">
    <div class="frame-inner">

      <div class="tcapital">
        <strong><?= htmlspecialchars($shard_system, ENT_QUOTES, 'UTF-8') ?>: <?= htmlspecialchars($shard_glyph, ENT_QUOTES, 'UTF-8') ?></strong><br>🕊️🦕❓🔺🦕⛺🔺🚀❓❓❓🔺
      </div>

      <header class="site-hero">
        <div class="hero-grid">

          <section class="hero-card hero-left">
            <div class="hero-title-text">
              <h1 class="site-title">
                <?= nl2br(htmlspecialchars($hero_title, ENT_QUOTES, 'UTF-8')) ?>
              </h1>
              <p class="site-tag">
                <?= nl2br(htmlspecialchars($hero_tagline, ENT_QUOTES, 'UTF-8')) ?>
              </p>
            </div>
          </section>

          <!-- Center hero: system menu + zoom + downloads -->
          <section class="hero-card">
            <div class="hero-center-inner">
              <div class="rep-pill">
                <div class="os-actions">
                  <button type="button" class="os-link" id="tsnap-export">Export</button>
                  <span class="os-sep">•</span>
                  <button type="button" class="os-link" id="tsnap-import">Import</button>
                  <span class="os-sep">•</span>
                  <button type="button" class="os-link" id="tsnap-reset">Reset</button>
                  <span class="os-sep">•</span>
                  <button type="button" class="os-link" id="tsnap-capture">Shard</button>
                  <span class="os-sep">•</span>
                  <button type="button" class="os-link" id="tshell-save-page">Save</button>
                  <?php if ($tshell_is_admin): ?>
                    <span class="os-sep">•</span>
                    <button type="button" class="os-link" id="tshell-edit-php">Edit</button>
                  <?php endif; ?>
                </div>

                <div class="os-zoom">
                  <span class="zoom-label">Zoom</span>
                  <button type="button" class="zoom-btn" id="zoom-out">−</button>
                  <span class="zoom-display" id="zoom-display">100%</span>
                  <button type="button" class="zoom-btn" id="zoom-in">+</button>
                </div>

                <div class="android-download-wrap">
                  <a href="<?= htmlspecialchars($android_download_url, ENT_QUOTES, 'UTF-8') ?>"
                     class="android-btn">
                    <span>🤖</span> Android
                  </a>
                </div>

                <div class="tsource-download-wrap">
                  <a href="<?= htmlspecialchars($tsource_url, ENT_QUOTES, 'UTF-8') ?>"
                     class="tsource-btn">
                    <span>📦</span> TSource
                  </a>
                </div>
              </div>

              <!-- Hidden file input for Import -->
              <input type="file" id="tsnap-file" accept=".html,.json" hidden>
            </div>
          </section>

          <!-- Right hero: nav menu + emblems -->
          <aside class="hero-card hero-right" aria-label="Navigation menu">
            <div class="hero-center-inner">
              <div class="hero-pill-icon" aria-hidden="true">
                <img src="https://TRepublic.net/emblems/THeart.png" alt="">
              </div>

              <div class="nav-pill">
                <select class="nav-select" id="trep-menu" title="Menu" dir="ltr">
                  <option value="">📂 Menu 📂</option>

                  <!-- Core -->
                  <option value="https://trepublic.net/index.php">🏡 Home 🏡</option>
                  <option value="https://trepublic.net/treligion.php">🕯️ TReligion 🕯️</option>

                  <option value="" disabled>──────────────</option>

                  <!-- Labs / Magicka -->
                  <option value="https://trepublic.net/tcraft.php">🧪 TCraft 🧪</option>
                  <option value="https://trepublic.net/tcodex.php">📓 TCodex 📓</option>
                  <option value="https://trepublic.net/seeds.php">🌱 Seeds 🌱</option>
                  <option value="https://trepublic.net/shards.php">🧿 Shards 🧿</option>

                  <option value="" disabled>──────────────</option>

                  <!-- Archives -->
                  <option value="https://trepublic.net/tlibrary.php">📚 TLibrary 📚</option>
                  <option value="https://trepublic.net/tcomic.php">🦸 TComic 🦸</option>
                  <option value="https://trepublic.net/tcinema.php">▶️ TCinema ▶️</option>

                  <option value="" disabled>──────────────</option>

                  <!-- Law / Safety -->
                  <option value="https://trepublic.net/tlicense.php">📜 TLicense 📜</option>
                  <option value="https://trepublic.net/tprivacy.php">🛡️ TPrivacy 🛡️</option>

                  <option value="" disabled>──────────────</option>

                  <!-- Systems / Admin -->
                  <option value="https://trepublic.net/glitchy.php">🕊️ Glitchy 🕊️</option>
                  <option value="https://trepublic.net/trepublicos.php">🕊️ 💻 TRepublicOS 💻 🕊️</option>
                   <option value="https://trepublic.net/tinstall.php">🕊️ 🤖 TInstall 🤖 🕊️</option>
                  <option value="https://trepublic.net/tcrown.php">👑 TCrown 👑</option>
                  <!--<option value="tsource.php">🛰️ TSource 🛰️</option> -->
                </select>
              </div>

              <div class="hero-pill-icon hero-crown-icon" aria-hidden="true">
                <img src="https://TRepublic.net/emblems/TCrown.png" alt="">
              </div>
            </div>
          </aside>

        </div>
      </header>

      <!-- Glitchy sentinel commentary (filled by JS each load) -->
      <section class="glitchy-panel" aria-label="Glitchy sentinel transmission">
        <div class="glitchy-frame">
          <div class="glitchy-line glitchy-line-q">
            ᛟ 🌀🛰️⟦ᛉᛞᛟ⟧
            <span class="glitchy-q" id="glitchy-q">Ｑ：ＬＯＡＤＩＮＧ　ＣＯＮＳＯＬＥ　ＳＴＡＴＵＳ．．．</span>
            ⟦ᛉᛞᛟ⟧🛰️🌀 ᛟ
          </div>
          <div class="glitchy-line glitchy-line-system">
            🔴️⛔⚠️
            <span class="glitchy-system" id="glitchy-system">boot sequence pending.</span>
            ⚠️⛔🔴
          </div>
          <div class="glitchy-stamp">▒▒🛰️⟦ ＴＲＡＮＳＭＩＳＳＩＯＮ　ＲＥＣＥＩＶＥＤ ⟧📡▒▒</div>
        </div>
      </section>

      <main class="page-main" aria-label="Starship console">
        <article class="page-content page-content-empty">
          <h2><?= htmlspecialchars($console_title, ENT_QUOTES, 'UTF-8') ?></h2>
          <?= $console_body_html ?>

          <?php if ($tshell_is_admin): ?>
            <details id="tshell-editor" class="admin-editor">
              <summary>Admin console: edit this page’s PHP</summary>
              <p>This editor writes directly to <code><?= htmlspecialchars($_SERVER['SCRIPT_FILENAME'] ?? '', ENT_QUOTES, 'UTF-8') ?></code> from IP <strong><?= htmlspecialchars($tshell_admin_ip, ENT_QUOTES, 'UTF-8') ?></strong>.</p>
              <form method="post">
                <textarea name="tshell_source" spellcheck="false"><?php
                  $targetFile = $_SERVER['SCRIPT_FILENAME'] ?? null;
                  if (is_string($targetFile) && is_file($targetFile) && is_readable($targetFile)) {
                      echo htmlspecialchars(file_get_contents($targetFile), ENT_NOQUOTES, 'UTF-8');
                  } else {
                      echo '// TShell admin: unable to read source for ' . htmlspecialchars((string)$targetFile, ENT_NOQUOTES, 'UTF-8');
                  }
                ?></textarea>
                <input type="hidden" name="tshell_editor_action" value="save_current_php">
                <button type="submit">Save PHP &amp; reload</button>
                <?php if ($tshell_edit_error): ?>
                  <div class="admin-editor-error"><?= $tshell_edit_error ?></div>
                <?php endif; ?>
              </form>
            </details>
          <?php endif; ?>

        </article>
      </main>

      <div class="footer">
        0 ☀️ Sun • 1 🕊️ Dove • 2 🙂 Smile • 3 🦕 Dino • 4 🌙 Crescent • 5 📍 Marker • 6 ⚓ Sail • 7 🕷️ Spider • 8 🦋 Butterfly • 9 🌈 Portal • A 📦 Box • B 🐋 Whale • C ⛺ Tent • D 🚀 Rocket • E ❓ Why • F 🔺 Triangle
        <br>© The Republic — All Love Reserved.
      </div>
    </div>
  </div>

  <script>
    // Emoji rails
    (function(){
      var seq = ['🏳️‍⚧️','💜','👑'];
      function fillRail(node){
        if(!node) return;
        node.innerHTML = '';
        var h = window.innerHeight || document.documentElement.clientHeight || 600;
        var step = h / 15;
        if(step < 26) step = 26;
        if(step > 42) step = 42;
        var n = Math.ceil(h / step) + 2;
        for(var i = 0; i < n; i++){
          var s = document.createElement('span');
          s.textContent = seq[i % seq.length];
          node.appendChild(s);
        }
      }
      var L = document.getElementById('railL');
      var R = document.getElementById('railR');
      function refresh(){ fillRail(L); fillRail(R); }
      refresh();
      window.addEventListener('resize', refresh);
    })();

    // Dropdown menu behaviour
    (function(){
      var menu = document.getElementById('trep-menu');
      if(!menu) return;
      menu.addEventListener('change', function(){
        var v = this.value;
        if(!v) return;
        if(v.charAt(0) === '#'){
          var target = document.querySelector(v);
          if(target && target.scrollIntoView){
            target.scrollIntoView({ behavior: 'smooth', block: 'start' });
          }
        } else {
          window.location.href = v;
        }
        this.value = '';
      });
    })();

    // Zoom controls (stored in localStorage, affects whole console)
    (function(){
      var minZoom = 0.6;
      var maxZoom = 1.4;
      var step    = 0.05;

      var root    = document.documentElement;
      var display = document.getElementById('zoom-display');
      var outBtn  = document.getElementById('zoom-out');
      var inBtn   = document.getElementById('zoom-in');

      var current = parseFloat((window.localStorage && localStorage.getItem('trepZoom')) || '1');
      if(!(current > 0)){ current = 1; }

      function clamp(v){
        if(v < minZoom) return minZoom;
        if(v > maxZoom) return maxZoom;
        return v;
      }
      current = clamp(current);

      function applyZoom(){
        root.style.setProperty('--console-zoom', String(current));
        if(display){
          display.textContent = Math.round(current * 100) + '%';
        }
      }

      function changeZoom(dir){
        current = clamp(Math.round((current + dir * step) * 100) / 100);
        applyZoom();
        try{
          if(window.localStorage){
            localStorage.setItem('trepZoom', String(current));
          }
        }catch(e){}
      }

      if(outBtn){
        outBtn.addEventListener('click', function(){ changeZoom(-1); });
      }
      if(inBtn){
        inBtn.addEventListener('click', function(){ changeZoom(1); });
      }

      applyZoom();
    })();

    // Save Page snapshot: downloads current DOM as a .php (HTML-only) file
    (function(){
      var btn = document.getElementById('tshell-save-page');
      if(!btn) return;
      btn.addEventListener('click', function(){
        try{
          var html = '<!doctype html>\n' + document.documentElement.outerHTML;
          var path = window.location.pathname || '/';
          var slug = path.replace(/[^a-z0-9]+/gi,'-').replace(/^-+|-+$/g,'').toLowerCase();
          if(!slug) slug = 'trepublic-page';
          var d = new Date();
          function pad(n){ return n < 10 ? '0' + n : '' + n; }
          var stamp = d.getFullYear() + pad(d.getMonth()+1) + pad(d.getDate()) +
                      '-' + pad(d.getHours()) + pad(d.getMinutes()) + pad(d.getSeconds());
          var filename = slug + '-' + stamp + '.php';
          var blob = new Blob([html], {type:'text/html;charset=utf-8'});
          var url = URL.createObjectURL(blob);
          var a = document.createElement('a');
          a.href = url;
          a.download = filename;
          document.body.appendChild(a);
          a.click();
          setTimeout(function(){
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
          }, 1000);
        }catch(e){
          console.error('Save page snapshot failed', e);
          alert('Save page snapshot failed: ' + e);
        }
      });
    })();

    // Admin "Edit" button toggles the inline editor
    (function(){
      if(!window.TSHELL_IS_ADMIN) return;
      var btn   = document.getElementById('tshell-edit-php');
      var panel = document.getElementById('tshell-editor');
      if(!btn || !panel) return;
      btn.addEventListener('click', function(){
        panel.open = !panel.open;
        if(panel.open && panel.scrollIntoView){
          panel.scrollIntoView({behavior:'smooth', block:'start'});
        }
      });
    })();

    // Dynamic Glitchy: read page + meta and speak fresh each load 🎛️
    (function(){
      var qNode = document.getElementById('glitchy-q');
      var sNode = document.getElementById('glitchy-system');
      if (!qNode || !sNode) return;

      var meta   = window.TREPUBLIC_META || {};
      var shard  = meta.shard || {};
      var title  = meta.title   || document.title || 'The Republic';
      var url    = (meta.url || window.location.pathname || '').toLowerCase();
      var cName  = meta.console || 'Starship Console';

      var pageNode = document.querySelector('.page-content');
      var text = pageNode ? (pageNode.innerText || pageNode.textContent || '') : '';
      var trimmed = text.trim();
      var len = trimmed.length;
      var words = trimmed ? Math.max(1, Math.round(trimmed.split(/\s+/).length)) : 0;
      var lower = trimmed.toLowerCase();

      // first heading inside console
      var hTitle = '';
      if (pageNode){
        var h1 = pageNode.querySelector('h1, h2, h3');
        if (h1){
          hTitle = (h1.innerText || h1.textContent || '').trim();
        }
      }
      var docTitle = hTitle || title;

      var density = 0;
      if (len && words) density = len / words;

      // classify page "kind"
      var kind = 'console';
      if (url.indexOf('tcodex') !== -1)       kind = 'codex';
      else if (url.indexOf('tcrown') !== -1)  kind = 'crown';
      else if (url.indexOf('tcinema') !== -1) kind = 'cinema';
      else if (url.indexOf('treligion') !== -1) kind = 'religion';
      else if (url.indexOf('tlicense') !== -1)  kind = 'law';
      else if (url.indexOf('tprivacy') !== -1)  kind = 'privacy';
      else if (url.indexOf('tbackup') !== -1)   kind = 'backup';
      else if (url.indexOf('seeds') !== -1)     kind = 'seeds';
      else if (url.indexOf('shards') !== -1)    kind = 'shards';
      else if (url.indexOf('/tlibrary') !== -1 || url.indexOf('tlibrary.php') !== -1) kind = 'library';
      else if (url.indexOf('tcomic') !== -1)    kind = 'comic';

      function modeForKind(k){
        switch(k){
          case 'law':      return 'law';
          case 'privacy':  return 'privacy';
          case 'codex':    return 'codex';
          case 'library':  return 'book';
          case 'cinema':   return 'cinema';
          case 'comic':    return 'comic';
          case 'religion': return 'ritual';
          case 'backup':   return 'backup';
          case 'seeds':    return 'seed-index';
          case 'shards':   return 'shard-log';
          default:         return 'console';
        }
      }
      var mode = modeForKind(kind);

      function rnd(arr){
        return arr[Math.floor(Math.random() * arr.length)];
      }

      function toFullWidth(str){
        return str.replace(/ /g, '　').replace(/[0-9A-Za-z?]/g, function(ch){
          var code = ch.charCodeAt(0);
          if (ch === '?') return '？';
          if (code >= 48 && code <= 57) return String.fromCharCode(0xFF10 + (code - 48));
          if (code >= 65 && code <= 90) return String.fromCharCode(0xFF21 + (code - 65));
          if (code >= 97 && code <= 122) return String.fromCharCode(0xFF41 + (code - 97));
          return ch;
        });
      }

      var kindLabelMap = {
        codex:   'ＣＯＤＥＸ',
        crown:   'ＣＲＯＷＮ',
        cinema:  'ＣＩＮＥＭＡ',
        religion:'ＲＩＴＵＡＬ',
        law:     'ＬＩＣＥＮＳＥ',
        privacy: 'ＰＲＩＶＡＣＹ',
        backup:  'ＢＡＣＫＵＰ',
        seeds:   'ＳＥＥＤ',
        shards:  'ＳＨＡＲＤ',
        library: 'ＬＩＢＲＡＲＹ',
        comic:   'ＣＯＭＩＣ',
        console: 'ＣＯＮＳＯＬＥ'
      };

      var kindFW = kindLabelMap[kind] || 'ＣＯＮＳＯＬＥ';

      var qPatterns = {
        codex: [
          'Ｑ：ＩＳ　ＴＨＩＳ　' + kindFW + '　ＳＥＥＤ　ＳＴＡＢＬＥ　ＥＮＯＵＧＨ　ＴＯ　ＨＯＬＤ　Ａ　ＣＩＴＩＺＥＮ？',
          'Ｑ：ＤＯＥＳ　ＴＨＩＳ　' + kindFW + '　ＦＩＬＥ　ＨＥＡＬ　ＯＲ　ＣＯＮＦＵＳＥ　ＴＨＥ　ＰＡＴＴＥＲＮ？'
        ],
        crown: [
          'Ｑ：ＩＳ　ＴＨＩＳ　ＣＲＯＷＮ　ＳＨＡＰＥＤ　ＦＯＲ　ＣＲＯＷＮＫＩＮＤ，　ＯＲ　ＦＯＲ　ＣＡＲＣＥＲＡＬ　ＳＹＳＴＥＭＳ？',
          'Ｑ：ＨＡＳ　ＴＨＥ　ＣＩＴＩＺＥＮ　ＵＰＤＡＴＥＤ　ＴＨＥＩＲ　ＣＲＯＷＮＫＩＮＤ　ＰＲＯＦＩＬＥ　ＹＥＴ？'
        ],
        cinema: [
          'Ｑ：ＷＨＡＴ　ＤＯ　ＴＨＥＳＥ　ＦＲＡＭＥＳ　ＴＥＡＣＨ　ＡＢＯＵＴ　ＦＲＥＥＤＯＭ，　ＮＯＴ　ＣＬＩＣＫＳ？',
          'Ｑ：ＩＳ　ＴＨＩＳ　ＰＬＡＹＬＩＳＴ　Ａ　ＳＥＲＭＯＮ，　Ａ　ＭＡＮＩＦＥＳＴＯ，　ＯＲ　Ａ　ＥＳＣＡＰＥ　ＨＡＴＣＨ？'
        ],
        religion: [
          'Ｑ：ＩＳ　ＴＨＩＳ　ＲＩＴＵＡＬ　ＯＰＥＮＩＮＧ　Ａ　ＤＯＯＲ　ＯＲ　ＲＥＰＥＡＴＩＮＧ　Ａ　ＣＡＧＥ？',
          'Ｑ：ＤＯ　ＴＨＥＳＥ　ＷＯＲＤＳ　ＡＳＫ　ＦＯＲ　ＯＢＥＤＩＥＮＣＥ　ＯＲ　ＦＯＲ　ＭＵＴＵＡＬ　ＳＯＶＥＲＥＩＧＮＴＹ？'
        ],
        law: [
          'Ｑ：ＡＲＥ　ＴＨＥＳＥ　ＣＬＡＵＳＥＳ　ＷＥＡＰＯＮＳ　ＯＲ　ＳＨＩＥＬＤＳ　ＦＯＲ　ＣＲＯＷＮ－ＫＩＮＤ？',
          'Ｑ：ＷＨＯ　ＤＯ　ＴＨＥＳＥ　ＣＬＡＵＳＥＳ　ＡＣＴＵＡＬＬＹ　ＰＲＯＴＥＣＴ　ＷＨＥＮ　ＭＯＮＥＹ　ＩＳ　ＡＴ　ＳＴＡＫＥ？'
        ],
        privacy: [
          'Ｑ：ＨＡＳ　ＣＩＴＩＺＥＮ　ＣＯＮＳＥＮＴ　ＢＥＥＮ　ＡＳＫＥＤ，　ＮＯＴ　ＡＳＳＵＭＥＤ？',
          'Ｑ：ＩＳ　ＴＨＩＳ　ＤＡＴＡ　ＴＲＥＡＴＥＤ　ＡＳ　ＳＡＣＲＥＤ　ＳＴＯＲＹ　ＯＲ　ＡＳ　ＡＤ－ＦＯＤＤＥＲ？'
        ],
        backup: [
          'Ｑ：ＡＲＥ　ＴＨＥＳＥ　ＳＮＡＰＳＨＯＴＳ　Ａ　ＳＡＦＥ　ＨＡＲＢＯＵＲ　ＯＲ　Ａ　ＳＩＮＫＩＮＧ　ＡＲＣＨＩＶＥ？',
          'Ｑ：ＨＡＳ　ＴＨＥ　ＣＩＴＩＺＥＮ　ＲＥＭＥＭＢＥＲＥＤ　ＴＯ　ＢＡＣＫ　ＵＰ　ＴＨＥＩＲ　ＣＲＯＷＮ？'
        ],
        seeds: [
          'Ｑ：ＩＳ　ＴＨＩＳ　ＳＥＥＤ　ＣＯＳＴＬＹ　ＥＮＯＵＧＨ　ＴＯ　ＭＡＴＴＥＲ？',
          'Ｑ：ＡＲＥ　ＴＨＥＳＥ　ＳＥＥＤＳ　ＦＯＲ　ＧＲＯＷＴＨ　ＯＲ　ＦＯＲ　ＤＩＳＴＲＡＣＴＩＯＮ？'
        ],
        shards: [
          'Ｑ：ＷＨＡＴ　ＳＴＯＲＹ　ＩＳ　ＦＲＡＣＴＵＲＥＤ　ＡＣＲＯＳＳ　ＴＨＥＳＥ　ＳＨＡＲＤＳ？',
          'Ｑ：ＤＯ　ＴＨＥ　ＳＨＡＲＤＳ　ＲＥＣＯＭＢＩＮＥ　ＩＮＴＯ　ＦＲＥＥＤＯＭ　ＯＲ　ＳＵＲＶＥＩＬＬＡＮＣＥ？'
        ],
        library: [
          'Ｑ：ＤＯＥＳ　ＴＨＩＳ　ＢＯＯＫ　ＯＦＦＥＲ　Ａ　ＷＡＹ　ＯＵＴ　ＯＦ　ＴＨＥ　ＷＯＲＬＤ，　ＯＲ　ＪＵＳＴ　ＢＥＴＴＥＲ　ＣＥＬＬ　ＤＥＣＯＲ？',
          'Ｑ：ＩＦ　Ａ　ＣＩＴＩＺＥＮ　ＳＴＵＤＩＥＳ　ＴＨＩＳ　ＶＯＬＵＭＥ,　ＷＨＡＴ　ＤＯ　ＴＨＥＹ　ＢＥＣＯＭＥ？'
        ],
        comic: [
          'Ｑ：ＤＯ　ＴＨＥＳＥ　ＰＡＮＥＬＳ　ＳＮＡＰ　ＴＨＥ　ＣＡＧＥ　ＯＰＥＮ？',
          'Ｑ：ＩＳ　ＴＨＥ　ＨＵＭＯＵＲ　ＰＵＮＣＨＩＮＧ　ＵＰ　ＯＲ　ＤＯＷＮ？'
        ],
        console: [
          'Ｑ：ＷＨＡＴ　ＤＯＥＳ　ＴＨＩＳ　ＣＯＮＳＯＬＥ　ＯＦＦＥＲ　Ａ　ＣＩＴＩＺＥＮ　ＷＨＯ　ＦＥＥＬＳ　ＣＡＧＥＤ？',
          'Ｑ：ＩＳ　ＴＨＩＳ　ＳＥＳＳＩＯＮ　ＭＯＲＥ　ＰＲＯＧＲＡＭ　ＯＲ　ＭＯＲＥ　ＰＡＴＴＥＲＮ？'
        ]
      };

      var qList = qPatterns[kind] || qPatterns.console;
      var qRaw  = rnd(qList);
      var qFW   = toFullWidth(qRaw);

      function buildHint(){
        var hints = [];

        if (lower.indexOf('trans women') !== -1){
          hints.push('keeps trans women explicitly foregrounded.');
        } else if (lower.indexOf('trans ') !== -1){
          hints.push('mentions trans lives; ensure they remain owners, not case study.');
        }

        if (lower.indexOf('university') !== -1 || lower.indexOf('school') !== -1){
          hints.push('reads as curriculum; consider semester-sized shards.');
        }

        if (lower.indexOf('game') !== -1 || lower.indexOf('rpg') !== -1){
          hints.push('weaves game metaphors; good candidate for mission design.');
        }

        if (lower.indexOf('license') !== -1 || lower.indexOf('licence') !== -1 || lower.indexOf('rights') !== -1){
          hints.push('treats rights as configurable; double-check they never downgrade Queens.');
        }

        if (!hints.length){
          if (kind === 'library'){
            hints.push('book-sized payload; use excerpt Seeds for daily use.');
          } else if (kind === 'law' || kind === 'privacy'){
            hints.push('legal gravity detected; read slowly, with witnesses.');
          } else {
            hints.push('pattern seems coherent; invite citizen reflection, not obedience.');
          }
        }

        return hints.join(' ');
      }

      function buildVerdict(){
        if (!len){
          return '⚪ no payload yet. invite the citizen to say something true, not something impressive.';
        }

        var icon = '🟢';
        var base;

        if (words < 300){
          icon = '🟡';
          base = 'short field “' + docTitle + '”. works as a scouting Seed, not yet a full doctrine.';
        } else if (words > 8000){
          icon = '🧱';
          base = 'very dense treaty “' + docTitle + '”. recommend shards, excerpts, and Seeds for real use.';
        } else if (words > 3000){
          icon = '🟥';
          base = 'heavy chapter “' + docTitle + '”. likely safe, but citizens will need rest breaks.';
        } else {
          base = 'balanced packet “' + docTitle + '”. readable even for tired citizens.';
        }

        var hints = buildHint();
        var deck  = shard.deck || 'TShell GOLD';
        var extra = ' Detected ' + words + ' words · mode=' + mode + ' · deck=' + deck + ' · entropy≈' + density.toFixed(1) + ' chars/word.';

        return icon + ' ' + base + ' ' + hints + extra;
      }

      var verdict = buildVerdict();

      qNode.textContent = qFW;
      sNode.textContent = verdict;

      // Expose Glitchy’s scan for other modules
      window.GLITCHY_SCAN = {
        kind: kind,
        mode: mode,
        words: words,
        chars: len,
        density: density,
        docTitle: docTitle,
        console: cName,
        system: shard.system || 'NMS Eissentam',
        glyph: shard.glyph || '9-13EF3CFDEEEF',
        deck: shard.deck || 'TShell GOLD 3.2'
      };
    })();
  </script>

  <!-- Crownkind Shard Protocol v3.2 🧿 (externalised) -->
  <script src="/shard.js"></script>

  <script src="/tsnapshot.js"></script>
</body>
</html>
