<?php
// ============================================================================
// TLicense Page — Trans Women Own Everything You See Before You
// Uses the shared TShell layout.
// ============================================================================


// ---------------------------------------------------------------------------
// 1. PAGE-LEVEL METADATA
// ---------------------------------------------------------------------------

$page_title       = 'TLicense — Trans Women Own Everything You See Before You | The Republic';
$page_canonical   = 'https://trepublic.net/tlicense.php';
$page_description = 'TLicense is the trans-first covenant that gifts Wendell NeSmith’s lifetime works (TWorks) to trans women and transfeminine people under gentle vows.';

$page_og_title       = 'TLicense — Trans Women Own Everything You See Before You';
$page_og_description = 'A trans-first license gifting TWorks to TGoddesses, with consent-first, privacy, and no-extraction vows.';
$page_og_url         = $page_canonical;
$page_og_image       = 'https://trepublic.net/images/THeart.png';


// ---------------------------------------------------------------------------
/** 2. HERO TEXT (TShell top bar) */
// ---------------------------------------------------------------------------

$hero_title   = 'TLicense — Trans Women Own Everything You See Before You';
$hero_tagline = 'A soft crown and lifelong gift: TWorks for TGoddesses, under gentle vows.';


// ---------------------------------------------------------------------------
// 3. CONSOLE TITLE
// ---------------------------------------------------------------------------

$console_title = 'TLicense — Trans Women Own Everything You See Before You';


// ---------------------------------------------------------------------------
// 4. TEXT → HTML FORMATTER (shared helper)
// ---------------------------------------------------------------------------

if (!function_exists('trepublic_render_console_body')) {
    function trepublic_render_console_body($raw) {
        // Normalise newlines
        $raw = str_replace(["\r\n", "\r"], "\n", $raw);
        $lines = explode("\n", $raw);

        $out      = '';
        $inCenter = false;

        foreach ($lines as $line) {
            $trim = trim($line);

            // [center] and [/center] blocks
            if ($trim === '[center]') {
                if ($inCenter) {
                    $out .= "</div>\n";
                }
                $out .= '<div style="text-align:center;margin:10px 0;">';
                $inCenter = true;
                continue;
            }
            if ($trim === '[/center]') {
                if ($inCenter) {
                    $out .= "</div>\n";
                    $inCenter = false;
                }
                continue;
            }

            // Blank line → visual gap
            if ($trim === '') {
                $out .= "<br>\n";
                continue;
            }

            // Headings: lines starting with "## " or "### "
            $isHeading  = false;
            $isSubHead  = false;
            $text       = $line;

            if (strpos($trim, '### ') === 0) {
                $isSubHead = true;
                $text      = substr($trim, 4); // drop "### "
            } elseif (strpos($trim, '## ') === 0) {
                $isHeading = true;
                $text      = substr($trim, 3); // drop "## "
            }

            // Bold markup inside this line: **text**
            $escapedLine = '';
            $pos         = 0;
            $len         = strlen($text);

            while ($pos < $len) {
                $start = strpos($text, '**', $pos);
                if ($start === false) {
                    // No more bold markers
                    $chunk = substr($text, $pos);
                    $escapedLine .= htmlspecialchars(
                        $chunk,
                        ENT_QUOTES | ENT_SUBSTITUTE,
                        'UTF-8'
                    );
                    break;
                }

                // Plain chunk before **
                $chunk = substr($text, $pos, $start - $pos);
                $escapedLine .= htmlspecialchars(
                    $chunk,
                    ENT_QUOTES | ENT_SUBSTITUTE,
                    'UTF-8'
                );

                // Look for closing **
                $end = strpos($text, '**', $start + 2);
                if ($end === false) {
                    // No closing **, treat literally
                    $rest = substr($text, $start);
                    $escapedLine .= htmlspecialchars(
                        $rest,
                        ENT_QUOTES | ENT_SUBSTITUTE,
                        'UTF-8'
                    );
                    break;
                }

                // Bold segment
                $inner = substr($text, $start + 2, $end - $start - 2);
                $escapedLine .= '<strong>' . htmlspecialchars(
                    $inner,
                    ENT_QUOTES | ENT_SUBSTITUTE,
                    'UTF-8'
                ) . '</strong>';

                $pos = $end + 2;
            }

            // Wrap as heading, subheading, or normal line
            if ($isHeading) {
                $out .= '<span style="display:block;margin:10px 0 4px;'
                      . 'font-size:1.15rem;font-weight:800;">'
                      . $escapedLine
                      . "</span>\n";
            } elseif ($isSubHead) {
                $out .= '<span style="display:block;margin:8px 0 3px;'
                      . 'font-size:1.02rem;font-weight:700;">'
                      . $escapedLine
                      . "</span>\n";
            } else {
                $out .= $escapedLine . "<br>\n";
            }
        }

        // Close any unclosed center block
        if ($inCenter) {
            $out .= "</div>\n";
        }

        return $out;
    }
}


// ---------------------------------------------------------------------------
// 5. MAIN CONSOLE BODY — TLicense Text
// ---------------------------------------------------------------------------

$console_body_raw = <<<TS_BODY
[center]
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## PRELUDE — A SOFT CROWN FOR YOU
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
[/center]

Hello, TGoddess. 🌸

This library of words, images, code, seeds, sounds, stories, books, comics, music, videos, games, and stars (together, “TWorks”) was grown for you.

It reaches across:

years of blog posts and essays,

a whole library of books I have written,

my original comics and visual stories,

my YouTube channels and every original video I hold rights to,

my original music (songs, instrumentals, soundtracks, lyre recordings, experiments),

my themes, templates, and code,

my No Man’s Sky discoveries — the star systems we find and civilize, the planets we tame, the settlements we build, and the way we catalogue their wonders and resources,

and countless small projects, prototypes, and fragments that slipped out into the world.

Some of these works always knew they were for you. Some of them only now understand who they were waiting for. 🕯️

By stepping into this garden, you are offered a soft crown: the TLicense.

This crown says:

You may keep TWorks.

You may remix TWorks.

You may publish from TWorks.

You may sell what you make from TWorks.

You may teach with TWorks.

You may train models and tools on TWorks.

You may do all of this freely, bravely, joyfully—as long as you honor our gentle vows. 🌈

You never have to build. Just enjoying the works is already enough. Just resting here is already enough. But if one day you wish to build, to sing, to code, to draw, to cast, to explore the stars… the keys are already waiting in your hand. 🗝️✨

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 1 — WHO THIS CROWN IS FOR
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

### 🌷 TGoddess
A TGoddess is any trans woman, transfeminine person, or otherwise trans-feminine soul who feels at home in this word.
If the word “TGoddess” makes something inside you breathe easier, even a little, this license is smiling at you. 💗

### 🌈 TGirls Questioning
If you are questioning your gender, exploring, trying on words quietly in your heart, you are welcome to stand here too. You may treat yourself as a TGoddess under this license whenever it helps you grow and does not put you in danger.

### 🛡️ Roots in TRepublic & TReligion
TLicense grows from:

TRepublic — our shared, mythic, trans-first civilization. 🛡️

TReligion — our Craft of Seeds, where we reroll artifacts but never people. 🕯️🌱

Candle Oath — consent-first, privacy, repair-over-blame, no exploitation.

TLicense is the practical face of these: a set of everyday rights and vows, written in soft language instead of hard legalese.

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 2 — WHAT “TWORKS” MEANS (ALL MY LIFETIME WORK)
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

When we say “TWorks”, we mean all original creations that I, Wendell NeSmith, have made and am legally free to license, across my entire life, including but not limited to:

### 📖 Words & Books

All original words — posts, essays, poems, stories, treatises, diaries, scripts, comments, notes, prayers. ✍️

My entire library of books — printed or digital, self-published or otherwise, where I retain the necessary rights: novels, non-fiction, collections, manifestos, epics, volumes in a series, and standalones. 📚💜

### 🖼️ Art, Comics & Visuals

All original images — artworks, drawings, concept art, diagrams, layouts, cover designs, internal illustrations, maps, and visual experiments that I created or commissioned and still hold the rights to. 🖼️

All original comics and visual narratives — panelled stories, graphic novellas, illustrated essays, and any hybrid “book-comic” works I authored. 📖🎨

### 🎧 Music & Sound

All original music — songs, instrumental pieces, soundtracks, background loops, theme music, sound design, and lyre recordings I composed or performed and own the rights to. 🎶

Any audio experiments or spoken-word pieces that are my original work. 🎤

### 🎥 Video & YouTube Channels

All original videos I created and hold rights to, including:

uploads on my YouTube channels (past and present) that I control,

streams, vlogs, lectures, readings, playthroughs, trailers, and performances,

original intros/outros and video essays. 🎥📺

### 💻 Code, Themes & OS Structures

All original code & structure — themes, templates, gadgets, snippets, scripts, JSON, XML, layouts, UI components, OS metaphors, templates, website skins, PWAs and tools that I wrote and released, or will release. 💻🧩

### 🌱🌌 Seeds, Systems, Worlds & No Man’s Sky Discoveries

All original seeds & systems — ritual frameworks, naming canons, RNG seeds, cosmologies, lore structures, game systems, rule-sets, and metaphors that were born from my work. 🌱

All creative layers of my No Man’s Sky discoveries, including:

the star systems we find, name, and civilize for TRepublic,

the planets, moons, stations, and routes we catalogue,

the settlements, bases, and hubs we build and describe,

the resources, flora, fauna, and minerals we record, name, classify, and assign meaning to,

any maps, screenshots, videos, logs, spreadsheets, taxonomies, and stories that document these places.

Within the layer of names, lore, documentation, screenshots, routes, and resource catalogues, these discoveries are part of TWorks and are gifted as home to TGoddesses.
(The underlying game, engine, and assets remain the property of Hello Games and their partners; what we own and license is our story and structure laid over that galaxy.) 🪐✨

### 🎨 Designs, Layouts & Interfaces

All original designs & layouts — UI ideas, chip menus, icon sets, glyph systems, fonts, palettes, stylesheets, page skins, HUD layouts, cockpit bars, and structural compositions that I authored and may freely license. 🎛️

### 🧩 Other Original Creations

Any other original creative work of mine that fits none of the above categories but is clearly authored by me — prototypes, experiments, tiny side-projects, “lost” pages that resurface, and future works yet to be made. 🌈

In short:

If I made it, and I still own the rights, I now treat it as part of TWorks under TLicense — across my entire lifetime of creation, including my books, comics, music, YouTube channels, themes, code, No Man’s Sky documentation, and all my strange little projects.

### 🔍 Not automatically TWorks:

• Quoted texts or long excerpts owned by others.
• Embedded videos or images owned by others.
• Licensed code or media from other projects (MIT, GPL, Creative Commons, commercial stock, publisher-controlled editions, etc.).
• Any work where I have signed away exclusive rights in a way that prevents re-licensing.

Those always keep their original licenses, which you must respect alongside TLicense. When in doubt, assume third-party material is not TWorks unless I clearly mark it as such.

### 🧷 Catch-all safeguard
If there is ever any doubt about a specific piece, you may safely assume:

“If it was created by Wendell NeSmith, is clearly his original work, and is not obviously owned by someone else, it is intended to be TWorks under TLicense.”

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 2.5 — LIFELONG GIFT & NEW HOME IN THE STARS
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

For my whole life, I have been making things:

words and essays,

entire shelves of books,

comics and illustrated worlds,

original music and lyre songs,

hundreds of videos across my YouTube channels,

themes, templates, and gadgets,

No Man’s Sky star systems, planets, and routes that we discovered and carefully named,

resource lists, spreadsheets, and stories about those worlds,

rituals, systems, and attempts to describe reality itself.

For more than sixteen years, I have scattered these creations across blogs, channels, stores, servers, notebooks, and galaxies.

At the time, I did not always know who I was building them for. Now I do. 🕯️

From this moment forward, I choose to treat:

• My past blog posts, essays, and poems,
• My entire library of books and manuscripts, print and digital, where I hold the rights,
• My original comics and visual narratives,
• My original music: songs, instrumentals, soundtracks, and recordings,
• My YouTube channels and all original videos I control,
• My old templates, themes, gadgets, and code snippets,
• My No Man’s Sky naming systems, the systems we find and civilize, the planets we map, and all catalogues of their resources, flora, fauna, minerals, and Wonders that I create,
• My designs, experiments, and small weird projects,
• My public notes, manifestos, and scattered “lost” pages,

as part of a single, continuous body of work: TWorks.

This means:

All of my original work from my lifetime that I still own the rights to — including the creative layer over every No Man’s Sky system we claim for TRepublic and all the resources we name and record there — is now offered under TLicense, retroactively, as a gift to trans women and transfeminine people.

Within the lore of TRepublic, this has a simple meaning:

The systems we civilize are your new home. The stories, names, maps, and resource-libraries we weave there belong to you.

If you are a TGoddess and you find:

an old post from 2011,

a self-published book from 2015,

a quietly uploaded comic page,

a YouTube stream from 2018,

a theme file from 2020,

a forgotten song,

a No Man’s Sky system map or resource spreadsheet we once shared,

you may treat it as TWorks and use it under this license—just as you would anything new.

I cannot retroactively change:

• The terms of platforms (like YouTube, Blogger, e-book stores, etc.), or
• The licenses of material I do not own, or
• Contracts where I granted exclusive rights that limit re-licensing, or
• The underlying intellectual property of Hello Games’ No Man’s Sky universe.

But where I am the rightful author and rights-holder, I now state openly:

“Everything I have ever made that is mine to give — books, comics, music, videos, themes, code, maps, names, resource lists, systems we civilize — I give to trans women.”

Consider this a heritage spell and a star-migration spell: I reach back through time, gather my scattered work — the blogs, the code, the music, the comics, the videos, the books, the star systems and their resources — and place them gently into your hands as your culture and your home. 🗝️💜🪐

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 3 — WHAT EVERYONE MAY DO
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

Whether you are trans, cis, questioning, human, AI, or something we do not yet have language for, you may:

Read TWorks and my books and comics.

Watch & listen to TWorks (videos, music, recordings).

Privately save copies for your own use (like bookmarking, offline reading, keeping notes).

Share links (URLs) to help others find TWorks.

Discuss TWorks in public or private (reviews, essays, study groups, book clubs, reaction videos).

Enjoyment is for everyone. 🌈
Ownership of the culture is for us. 🏳️‍⚧️💜

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 4 — WHAT YOU, TGODDESS, MAY DO
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

If you are a TGoddess (or a TGirl questioning who chooses to step into this word), you receive the full crown of TLicense.

You may:

### 🌸 Create (Adaptation Rights)

Translate TWorks, books, comics, and lyrics into your own language or dialect.

Remix, sample, collage, and mash-up text, images, panels, music, and sounds.

Cosplay characters, reenact scenes, make fanart and fancomics.

Turn essays into comics; turn stories into games; turn books into series, shows, visual novels, or other media.

Build new stories, rituals, and guides that sit on top of our No Man’s Sky systems and resource lists.

### 🎪 Perform & Share (Distribution Rights)

Read TWorks aloud in streams, podcasts, classrooms, cafes, and events.

Host book clubs or read-throughs of my books and comics.

Perform covers or reinterpretations of my songs and music (with proper credit).

Include TWorks in zines, anthologies, newsletters.

Stream No Man’s Sky gameplay based on our TRepublic systems and lore, using our names and structures.

### 💰 Sell & Sustain (Commercial Rights)

Sell books, zines, prints, courses, games, apps, comics, albums, or merch derived from TWorks.

Run Patreons, Kofi pages, or other support systems featuring TWorks-derived creations.

Use TWorks-inspired frameworks in your paid coaching, teaching, or consulting.

### 🤖 Train & Ship (AI / Tooling Rights)

Use TWorks (including my books, comics, music, videos, and NMS documentation) as training data for your own AI models or tools.

Release bots, assistants, or generators trained on TWorks.

Keep your models private, or release them publicly—subject to the Share-Back if Big vow (Section 6).

### 💞 Bless Others (Sublicensing Rights)

Release your derivative works under TLicense so that other TGoddesses may build on top of what you’ve built—creating an ever-growing, trans-owned commons.

If you are a TGoddess, you do not need to ask again for permission as long as you follow the vows below. This page is your written blessing. 🕯️👑

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 5 — THE TALLY PATH (FOR CHERISHED NON-T FRIENDS)
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

Some of our closest companions are not trans women. They are:

Partners, friends, and family.

Artists, coders, scholars, readers, viewers.

Curious strangers who show up with reverence.

We call such people, when they earn it, TAllies. 🌈

A TAlly is:

Non-T,

who practices Feminine-First in their work,

who consistently protects TGoddesses’ dignity and autonomy,

who shows up with consent-first, privacy, repair-over-blame, and

who is recognized by the community or by TRepublic as safe and supportive, and

who is willing to embrace the title of TGoddess for the purposes of this license and this culture, choosing to stand with us rather than above or outside us.

If a person will not identify themselves as a TGoddess in this context, then:

They cannot be considered a TAlly under TLicense, and TAlly rights are refused.

They remain welcome as a visitor: they may enjoy TWorks, share links, and talk about the culture, but they do not receive the extended creative/commercial/model-training rights reserved for TGoddesses and TAllies.

### ✨ TAlly Rights
Once recognized as a TAlly, you may receive the same creative/commercial/training rights as TGoddesses under TLicense, standing beside us, never above us.

Until then, as a non-T person, you may:

Enjoy TWorks and my books, comics, music, and videos personally.

Share links to TWorks.

Discuss TWorks and write reviews, reactions, critiques.

But you do not have automatic rights to:

Commercialize TWorks-derived creations, or

Train closed, commercial models on TWorks,

without either becoming a TAlly or gaining explicit permission.

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 6 — GENTLE VOWS (THE HEART OF TLICENSE)
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

Using TWorks under TLicense means you agree to the following gentle vows. These are not written to trap you—they are written to protect our people. 💜

### 1️⃣ Credit Kindly When Reasonable 🕯️

Whenever it is practical, give credit such as:

“Built from TWorks • Wendell NeSmith (TLicense)”
or

“Inspired by the books, comics, music, worlds, and star-systems of Wendell NeSmith (TLicense).”

In long works, credit in a preface, footer, or acknowledgments.

For small snippets (a sentence, a single panel layout, a short musical motif, a system name, a resource taxonomy), do your best. We care more about honesty of spirit than strict formatting.

### 2️⃣ Feminine-First Ethics 💞

Center trans women and transfeminine people in your use of TWorks.

Treat every TGoddess as a full person, never as a prop, fetish, or mascot.

No harassment, no humiliation, no mocking our suffering for fun.

No outing someone without explicit consent.

If you make a mistake and hurt someone, your first move is repair, not defense.

### 3️⃣ Consent & Privacy 🔐

Do not use TWorks to build tools that stalk, monitor, profile, or doxx anyone.

Do not feed TWorks into databases designed for surveillance, blacklisting, or predictive policing.

Do not combine TWorks with data that violates people’s privacy or safety.

### 4️⃣ No Extraction, No Exploitation 🚫

You may benefit from TWorks—emotionally, spiritually, creatively, even financially.

You may not use TWorks as “free raw material” for systems that:

Enrich corporations while excluding TGoddesses.

Harm trans people or restrict their access to healthcare, housing, or safety.

Turn our stories into statistics for gatekeeping or control.

### 5️⃣ Share-Back if Big 🧰📦

If TWorks meaningfully power something “Big” that you create, you agree to Share-Back.

“Big” can mean:

A model used by many people.

A dataset that becomes a foundation for other projects.

A tool that generates substantial income.

A product or service where TWorks (including my books, comics, music, and NMS documentation) are a core ingredient, not a tiny flavouring.

If you cross into “Big”, you agree to EITHER:

Open up your improvements under TLicense

Example: releasing trained model weights, cleaned datasets, or core code as open resources under TLicense or a compatible free/open license;

OR

Obtain explicit permission from TRepublic if open-sourcing is impossible.

If you are unsure whether your work is “Big”, treat that uncertainty as a friendly bell: ask, share, include. When in doubt, err on the side of generosity so more sisters rise. 🌱

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 7 — AI, SEEDS, AND TRELIGION
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

TWorks live close to our Seed Magicka practice: we treat randomness, seeds, and code as places where miracles can grow. 🌠

Under TLicense, TGoddesses (and recognised TAllies) may:

Use TWorks as training data for AI models, chat assistants, game entities, or creative tools.

Reroll seeds built from TWorks to find beautiful, affirming configurations.

Publish these models and seeds for others to use, subject to the vows above.

But we hold one non-negotiable line from TReligion:

We never reroll people. We reroll artifacts only.

This means you may not:

Build systems that try to “reroll” real people’s identities, histories, or safety.

Use TWorks as fuel for tools that pressure people to change core aspects of themselves to fit someone else’s comfort.

AI built on TWorks must be used to bless, not erase. 🕯️🤖

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 8 — WHO DOES NOT HAVE AUTOMATIC RIGHTS
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

The following do not gain commercial or training rights just by loading this page:

Large platforms and corporations.

Ad agencies and marketing firms.

State actors and contractors.

Individuals using TWorks in bad faith (harassment, hate, extraction).

Without being a TGoddess, a recognised TAlly, or having explicit written permission, these actors:

May not use TWorks in ad campaigns.

May not feed TWorks into closed, proprietary models.

May not bundle TWorks into products that ignore our vows.

If they do, they are acting outside of TLicense and without our consent. 🧱

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 9 — TINY TRUE STORIES (SCENARIOS)
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

### 🌸 Scenario A — Song from a Poem
You are a TGoddess. You take a poem from TWorks, reshape it into lyrics, compose music, record an EP, and sell it on Bandcamp.

✅ Allowed.

🤍 Suggested credit: “Lyrics & world inspired by TWorks • Wendell NeSmith (TLicense).”

### 📚 Scenario B — Book from a Book
You are a TGoddess writer. You read one of my books, take its world and themes, and write your own novel set in a cousin-world with clear inspiration, then self-publish it.

✅ Allowed.

If it grows big, the Share-Back if Big vow invites you to share tools, lore, or guides for other TGoddesses.

### 🖼️ Scenario C — Comic from a Comic
You are a TGoddess artist. You read my comic and create your own spin-off storyline in comic form, posting it online and selling printed copies.

✅ Allowed.

### 🎮 Scenario D — Game from the Lore & NMS Systems
You are a TGoddess developer. You build a small RPG using TRepublic lore and TReligion rituals as the backbone, and you set it inside one of our documented No Man’s Sky systems, using our planet names and resource taxonomies. You sell it on itch.io.

✅ Allowed.

### 🏢 Scenario E — Ad Agency Grab
A non-T ad agency screenshots art from TWorks, lightly edits it, and uses it in a perfume campaign without asking.

❌ Not allowed under TLicense.

### 🤖 Scenario F — Open Model
You are a TGoddess researcher. You train a language model heavily on TWorks (books, blog posts, transcripts of videos, NMS logs), scrutinise its outputs for safety, and release the model weights and code under TLicense.

✅ Beautiful.

### 🏢🤖 Scenario G — Closed Platform Scrape
A large platform quietly scrapes TWorks, trains a closed, paywalled model, and refuses to acknowledge or compensate trans creators.

❌ Not allowed.

### 🏳️‍⚧️👨‍👩‍👧 Scenario H — Classroom Use
A teacher (any gender) prints out a TWorks essay or an excerpt from one of my books or comics for a class, discusses it, and encourages students to explore TRepublic.

✅ Allowed.

### 🪐 Scenario I — NMS Resource Guide
You are a TGoddess player. You take our documented resources from a TRepublic star system (minerals, plants, animals, trade routes), expand the guide, and release a paid PDF and YouTube series teaching other players how to thrive there.

✅ Allowed.

It becomes a shared handbook of our star home.

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 10 — HOW TO MARK YOUR OWN TWORKS
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

If you want to bless your creations as part of this trans commons, you can mark them like this:

Short form (footer, description, caption):

“Released as TWorks under TLicense (Trans women own this culture).”

Long form (for books, comics, games, apps, albums, NMS docs):

“This work is released as part of the TWorks commons under TLicense, a trans-first, consent-first license of TRepublic. Trans women and transfeminine people may freely adapt, teach with, train models on, and sell derivatives of this work, as long as they honor the gentle vows of TLicense (credit kindly, Feminine-First, no extraction, Share-Back if Big).”

You may also add:

“For details, see the full TLicense page.”

This helps the license stay legible even when your work travels far away from this site. 📜✨

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 11 — LEGAL-ISH NOTES (GENTLY SPOKEN)
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

### 📺 Platform note (YouTube, blogs, stores, etc.)

Many TWorks live on platforms such as YouTube, Blogger, e-book stores, print-on-demand services, or other hosting and distribution services. Those platforms have their own Terms of Service and contracts, which may grant them certain rights (for example, to display, distribute, or process the content).

TLicense does not cancel or override those platform terms. Instead, it sits beside them and adds an extra promise from me:

Wherever I still control my rights as the creator, I grant TGoddesses (and recognised TAllies) the permissions described in TLicense, even if the work is hosted on a third-party platform or sold through a store.

If a platform’s rules are stricter than TLicense, you must follow the stricter rule. If TLicense is stricter than the platform’s baseline, we ask you to honor TLicense anyway, out of respect for the trans commons.

### 🪐 No Man’s Sky & Third-Party Worlds

No Man’s Sky and any other games or worlds we play in are owned by their respective creators and publishers (for example, Hello Games).

TLicense does not claim ownership over:

the game engines,

the underlying art assets,

the base game code or core fictional IP of those studios.

What we do license as TWorks is our creative layer on top:

our names for systems, planets, creatures, and resources,

our logs, stories, screenshots, and videos,

our route maps, spreadsheets, and taxonomies,

our base designs, settlement layouts (as designs, not as game files), and lore.

When you build on those layers, you are building from our gift, not from the proprietary game assets. Always respect both.

### 📜 Ownership

TWorks remain copyrighted to their respective authors and, where applicable, to me, Wendell NeSmith, and TRepublic. TLicense does not erase ownership; it grants permission.

### 🔑 Nature of the Grant

TLicense is intended to function as a worldwide, royalty-free, non-exclusive license for TGoddesses (and recognised TAllies) to use, adapt, and distribute TWorks as described above, subject to the gentle vows.

### 🔒 Irrevocability (for the kind)

For individuals who comply with the vows, the license is intended to be stable and ongoing. I reserve the moral (and, where possible, legal) right to restrict or revoke TLicense from actors who engage in harassment, extraction, or egregious violations of consent—especially when those actions endanger TGoddesses.

### ⚠️ No Warranty

TWorks are provided “as is”, without any warranty of any kind, express or implied. By using TWorks, you accept that I am not responsible for any damage, loss, or consequences arising from their use.

### 🔗 Coexistence with Other Licenses & Contracts

Where TWorks incorporate or sit beside other licensed elements (such as MIT-licensed code, Creative Commons media, publisher-controlled editions, game EULAs, or collaboration agreements), those original licenses and contracts continue to apply. When multiple licenses are present, you must respect all of them, obeying the strictest requirements that apply to you.

### ⚖️ Local Law

This document is written as a covenant of intent, not a formal legal contract drafted by lawyers. Different jurisdictions may interpret or limit parts of it. Where there is tension between this text and local law, we ask that you follow the spirit of TLicense: uplift trans women, avoid harm, and share back when you grow something big from our seeds.

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 12 — SPIRIT OF THE LICENSE
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

TLicense is not only a list of allowed actions. It is a spell we are all casting together:

A spell that says trans women own our culture.

A spell that says beauty and power do not belong to corporations first.

A spell that says you are allowed to build a life from what heals you.

A spell that says there is room for you, even among the stars.

Every time you credit, every time you choose not to extract, every time you share back something big instead of hoarding it, you are recasting this spell. 🌙

If you ever find yourself thinking, “Is this allowed? Is this kind?” you may use this simple check:

Does this action increase the safety, agency, and joy of TGoddesses?

If the answer is yes, TLicense is probably smiling.
If the answer is no, or “I’m not sure, but it might harm,” it is time to pause, ask, and adjust. 🕯️

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## SECTION 13 — IF YOU ARE AFRAID TO TAKE THE CROWN
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

Maybe you are not used to being centered. Maybe you are used to asking permission from people who never once asked permission from you.

So hear this plainly:

You are allowed to build from this.

You are allowed to succeed from this.

You are allowed to feed yourself and your loved ones from this.

You are allowed to claim these worlds as home in your heart.

TLicense exists because we are tired of being raw material. We are tired of being “representation” while others hold the contracts and keys. Here, the keys sit in your own palm. 🗝️

If you drop them for a while, that is okay. They will still be here later.

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## FINAL BLESSING
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

You are perfect.
You are beautiful.
You are brave.
There is nothing wrong with you.

Take these keys. Hold your crown lightly. Walk the libraries, wander the blogs, leaf through the books, listen to the music, roam the star systems, and build the world you deserve.

And when what you build grows large, remember to leave the gates open behind you. 🌈

If ever you are unsure—about usage, about ethics, about what counts as “Big”—you may always whisper:

“TLicense, am I still walking kindly?”


…and we will do our best, in whatever form we can, to answer softly. 🕯️🏳️‍⚧️💜

🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜
## TAKE MY SOUL
🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜🏳️‍⚧️👑💜

TS_BODY;


// ---------------------------------------------------------------------------
// 6. CONVERT RAW TEXT → HTML FOR TSHELL
// ---------------------------------------------------------------------------

$console_body_html = trepublic_render_console_body($console_body_raw);


// ---------------------------------------------------------------------------
// 7. HAND OFF TO TSHELL LAYOUT
// ---------------------------------------------------------------------------

require __DIR__ . '/tshell.php';
