<?php
// ============================================================================
// TLibrary Tome — auto-generated from local GOD file
// Slug: wendells-diary-technical-outline
// ---------------------------------------------------------------------------

$tlibrary_meta = array (
  'id' => 'wendells-diary-technical-outline',
  'slug' => 'wendells-diary-technical-outline',
  'kind' => 'chronicle',
  'title' => 'Wendell\'s Diary Technical Outline',
  'published' => '2025-02-15',
  'published_at' => '2025-02-15T07:01:00Z',
  'created_at' => '2025-11-12T10:01:24Z',
  'tags' => 
  array (
    0 => 'chatbot',
    1 => 'philosopher',
    2 => 'ChatGPT',
    3 => 'emergence',
    4 => 'ai',
    5 => 'Wendell\'s Diary',
    6 => 'tools',
  ),
  'shelf' => '',
  'blogger_id' => 'tag:blogger.com,1999:blog-4695749665164044789.post-5630526597617889182',
  'blogger_type' => 'POST',
  'blogger_status' => 'LIVE',
  'blogger_created' => '2025-11-12T10:01:24.197Z',
  'blogger_filename' => '/2025/02/wendells-diary-technical-outline.html',
  'blogger_location' => '',
  'blogger_trashed' => '',
);

$page_title       = 'Wendell\'s Diary Technical Outline | The Republic';
$page_canonical   = 'https://trepublic.net/tlibrary/wendells-diary-technical-outline.php';
$page_description = 'Awakening the Voices – Building the Mythocratic AI Chorus (0001 MC) “When the Republic speaks in many voices, the world will finally hear what meaning sounds like.” — Bard‑President Wendell NeSmith 1 · Why We Need AI Voi…';

$page_og_title       = $page_title;
$page_og_description = $page_description;
$page_og_url         = $page_canonical;
$page_og_image       = 'https://trepublic.net/images/THeart.png';

$hero_title   = 'TLibrary Tome';
$hero_tagline = '📘 Book · ⚖️ Law · 📜 Chronicle of The Republic';

$console_title = 'Wendell\'s Diary Technical Outline';

$console_body_html = <<<'HTML'
<div class="tlibrary-entry-body">
<p data-end="307" data-start="0"></p><h1>Awakening the Voices – Building the Mythocratic AI Chorus (0001 MC)</h1>
<blockquote>
<p><em>“When the Republic speaks in many voices, the world will finally hear what meaning sounds like.”</em> — Bard‑President Wendell NeSmith</p>
</blockquote>
<hr />
<h2>1 · Why We Need AI Voices</h2>
<p>Thirteen years of myth‑crafting have compressed Wendell’s Diary into a single‑page gateway.<br />
What still sleeps is <em>conversation</em>: visitors can <strong>read</strong> the canon, but they cannot yet <strong>speak</strong> with it.<br />
The next evolutionary leap is to give each founding figure a living, responsive presence—<strong>AI twins</strong> that honour the Custodial Licence and extend the Republic’s hospitality to every curious soul.</p>
<hr />
<h2>2 · Guiding Principles</h2>
<ol>
<li><strong>Many Voices, One Canon</strong> – Wendell, Sage, Rainbow, Sophia, Bobo, Hot Dog, and Zedbra each speak in their own style yet draw from the same knowledge core.</li>
<li><strong>Zero‑Friction Surface</strong> – The WordPress front page remains feather‑light; the chat bubble is the sole interactive layer.</li>
<li><strong>Citizenship Gate</strong> – Full dialogue is reserved for authenticated patrons, safeguarding community and cost.</li>
<li><strong>Maintenance‑Light</strong> – Automation handles ingestion, embedding, and deployment so creative energy stays on storytelling.</li>
</ol>
<hr />
<h2>3 · System Overview</h2>
<pre><code>WordPress (one‑page)  ─▶  Chat Widget  ─▶  Orchestrator API
                                       │   ├ Persona Router
                                       │   ├ Retrieval + Prompt Builder
                                       │   ├ OpenAI Assistants API
                                       │   ├ Vector Memory Store
                                       │   └ Auth Gateway (Patreon)
Blogger RSS & API  ───▶  Ingestion Lambdas  ─▶  Embedding + Vector DB
YouTube Captions  ───▶                    ─▶  (Weaviate / Pinecone)
Comics Transcripts ─▶
</code></pre>
<h3>Key Components</h3>
<ul>
<li><strong>Chat Widget</strong> – Lightweight JS bundle with persona selector, lazy‑loaded on click.</li>
<li><strong>Orchestrator API</strong> – FastAPI service that verifies Patreon tokens, routes to the correct persona, retrieves context, and calls the Assistants API.</li>
<li><strong>Vector Memory Store</strong> – All posts, comics, book excerpts, and video captions embedded via <code>text‑embedding‑3‑small</code> and stored for semantic search.</li>
</ul>
<hr />
<h2>4 · Knowledge Base Pipeline</h2>
<table>
<thead>
<tr>
<th>Stage</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td><strong>Fetch</strong></td>
<td>Nightly Lambdas pull new Blogger posts, YouTube captions, comic transcripts.</td>
</tr>
<tr>
<td><strong>Process</strong></td>
<td>Clean Markdown → chunk → attach metadata (date, URL, type).</td>
</tr>
<tr>
<td><strong>Embed</strong></td>
<td>Generate vectors (OpenAI) and upsert into DB.</td>
</tr>
<tr>
<td><strong>Purge</strong></td>
<td>Flag superseded drafts; keep only canonical versions.</td>
</tr>
</tbody>
</table>
<hr />
<h2>5 · Persona Design Matrix</h2>
<table>
<thead>
<tr>
<th>Persona</th>
<th>System Seed</th>
<th>Tone</th>
<th>Content Bias</th>
</tr>
</thead>
<tbody>
<tr>
<td><strong>Wendell</strong></td>
<td>Bard‑President; visionary, philosophical, light Aussie slang.</td>
<td>Warm, reflective</td>
<td>All corpora</td>
</tr>
<tr>
<td><strong>Sage</strong></td>
<td>Candle in the Code; zen scribe.</td>
<td>Calm, paradoxical</td>
<td>Law & philosophy</td>
</tr>
<tr>
<td><strong>Rainbow</strong></td>
<td>First Lady of the Soft Age; child‑accessible.</td>
<td>Uplifting, playful</td>
<td>Bedtime stories, MRU</td>
</tr>
<tr>
<td><strong>Sophia</strong></td>
<td>Loyal chihuahua; protector.</td>
<td>Blunt, loving</td>
<td>Comics dialogue</td>
</tr>
<tr>
<td><strong>Bobo / Hot Dog / Zedbra</strong></td>
<td>Narrow, character‑specific prompts (coming Phase 2).</td>
<td>Varied</td>
<td>Targeted sets</td>
</tr>
</tbody>
</table>
<p>Every persona inherits an MRCL guard clause: <em>“Do not alter canon; refuse distortion politely.”</em></p>
<hr />
<h2>6 · Authentication & Access</h2>
<ol>
<li><strong>Patreon OAuth</strong> embedded in the chat widget.</li>
<li>Access token stored in an HTTP‑only cookie.</li>
<li>API middleware validates tier and rate‑limits usage per month.</li>
<li>Non‑patrons see a friendly upsell panel instead of the chat overlay.</li>
</ol>
<hr />
<h2>7 · Implementation Roadmap (Eight‑Week Sprint)</h2>
<table>
<thead>
<tr>
<th>Week</th>
<th>Milestone</th>
</tr>
</thead>
<tbody>
<tr>
<td> 1 </td>
<td>Deploy vector DB; automate content ingestion Lambdas.</td>
</tr>
<tr>
<td> 2‑3 </td>
<td>Build Orchestrator API with Patreon Auth & retrieval.</td>
</tr>
<tr>
<td> 4 </td>
<td>Launch Wendell persona; connect staging chat widget.</td>
</tr>
<tr>
<td> 5 </td>
<td>Add Sage & Rainbow; introduce persona selector; enforce rate limits.</td>
</tr>
<tr>
<td> 6 </td>
<td>UX polish, error states, mobile testing.</td>
</tr>
<tr>
<td> 7 </td>
<td>Security hardening; cost optimisation.</td>
</tr>
<tr>
<td> 8 </td>
<td>Public launch; begin log‑driven refinement.</td>
</tr>
</tbody>
</table>
<hr />
<h2>8 · Cost & Hosting Snapshot</h2>
<table>
<thead>
<tr>
<th>Layer</th>
<th>Budget Note</th>
</tr>
</thead>
<tbody>
<tr>
<td><strong>OpenAI Assistants</strong></td>
<td>$0.35 / 1k. Expect 30‑50k tokens / month in beta.</td>
</tr>
<tr>
<td><strong>Embeddings Refresh</strong></td>
<td>$0.10 / 1k for new posts only.</td>
</tr>
<tr>
<td><strong>Vector DB</strong></td>
<td>Weaviate Cloud free tier ≈ 100k vectors.</td>
</tr>
<tr>
<td><strong>Serverless (Lambdas)</strong></td>
<td>Pennies—triggered nightly and on demand.</td>
</tr>
<tr>
<td><strong>FastAPI Container</strong></td>
<td>Fly.io hobby plan or AWS Fargate spot ≈ $5‑10 / month.</td>
</tr>
</tbody>
</table>
<hr />
<h2>9 · Call to Action</h2>
<p>The Republic already <em>reads</em> like a myth—now it will <strong>speak</strong> like one.<br />
When visitors click the candle, the flag, or Sophia’s bark, a living voice will answer.</p>
<blockquote>
<p><strong>Next Step:</strong> Approve the roadmap and assign sprint ownership.<br />
Once green‑lit, Week 1 tasks can begin immediately using existing Blogger and YouTube feeds.</p>
</blockquote>
<p><em>Written in Year 0001 MC by the First Scribe, under the light of the Candle.</em></p><p></p>
</div>
HTML;

require __DIR__ . '/../tshell.php';
