<?php
// ============================================================================
// TForge Seed Template — TCraft Page for The Republic 🌐
//
// This file is a sibling of index.php:
//
//   • Real TCraft page at: https://trepublic.net/tcraft.php
//   • A living template citizens can COPY, RENAME, and RESKIN for other
//     “engine room / tools / seeds” spaces.
//
// Authored for The Republic by:
//   Codey, Republic Systems Programmer 💻👑
//   (TShell + TForge seed for citizen-first power pages)
//
// ============================================================================


// ---------------------------------------------------------------------------
// 1. PAGE-LEVEL METADATA (how this page appears to the outside world)
// ---------------------------------------------------------------------------

$page_title       = 'TCraft — Seed Share | The Republic';
$page_canonical   = 'https://trepublic.net/tcraft.php';
$page_description = 'TCraft is the engine room of The Republic: a seed garden of paste-to-install scripts for life, reality systems, and No Man’s Sky, turning hard-won breakthroughs into reproducible power.';

$page_og_title       = 'TCraft — Seed Share';
$page_og_description = 'Seed Share for paste-to-install scripts that turn breakthroughs into reproducible power in life, reality systems, and No Man’s Sky.';
$page_og_url         = $page_canonical;
$page_og_image       = 'https://trepublic.net/images/THeart.png';


// ---------------------------------------------------------------------------
// 2. HERO TEXT (what appears in the TShell hero bar at the top)
// ---------------------------------------------------------------------------

$hero_title   = 'TCraft — Seed Share';
$hero_tagline = 'Paste-to-install scripts for life, reality & No Man’s Sky.';


// ---------------------------------------------------------------------------
// 3. CONSOLE TITLE (heading inside the starship console panel)
// ---------------------------------------------------------------------------

$console_title = 'TCraft — Seed Share';


// ---------------------------------------------------------------------------
// 4. TEXT → HTML FORMATTER (no regex, safe for huge emoji walls)
//    Same engine used in index.php
// ---------------------------------------------------------------------------

if (!function_exists('trepublic_render_console_body')) {
    function trepublic_render_console_body($raw) {
        // Normalise newlines
        $raw = str_replace(["\r\n", "\r"], "\n", $raw);
        $lines = explode("\n", $raw);

        $out      = '';
        $inCenter = false;

        foreach ($lines as $line) {
            $trim = trim($line);

            // [center] and [/center] blocks
            if ($trim === '[center]') {
                if ($inCenter) {
                    $out .= "</div>\n";
                }
                $out .= '<div style="text-align:center;margin:10px 0;">';
                $inCenter = true;
                continue;
            }
            if ($trim === '[/center]') {
                if ($inCenter) {
                    $out .= "</div>\n";
                    $inCenter = false;
                }
                continue;
            }

            // Blank line → visual gap
            if ($trim === '') {
                $out .= "<br>\n";
                continue;
            }

            // Headings: lines starting with "## "
            $isHeading = false;
            $text      = $line;
            if (strpos($trim, '## ') === 0) {
                $isHeading = true;
                $text      = substr($trim, 3); // drop "## "
            }

            // Bold markup inside this line: **text**
            $escapedLine = '';
            $pos         = 0;
            $len         = strlen($text);

            while ($pos < $len) {
                $start = strpos($text, '**', $pos);
                if ($start === false) {
                    // No more bold markers
                    $chunk = substr($text, $pos);
                    $escapedLine .= htmlspecialchars(
                        $chunk,
                        ENT_QUOTES | ENT_SUBSTITUTE,
                        'UTF-8'
                    );
                    break;
                }

                // Plain chunk before **
                $chunk = substr($text, $pos, $start - $pos);
                $escapedLine .= htmlspecialchars(
                    $chunk,
                    ENT_QUOTES | ENT_SUBSTITUTE,
                    'UTF-8'
                );

                // Look for closing **
                $end = strpos($text, '**', $start + 2);
                if ($end === false) {
                    // No closing **, treat literally
                    $rest = substr($text, $start);
                    $escapedLine .= htmlspecialchars(
                        $rest,
                        ENT_QUOTES | ENT_SUBSTITUTE,
                        'UTF-8'
                    );
                    break;
                }

                // Bold segment
                $inner = substr($text, $start + 2, $end - $start - 2);
                $escapedLine .= '<strong>' . htmlspecialchars(
                    $inner,
                    ENT_QUOTES | ENT_SUBSTITUTE,
                    'UTF-8'
                ) . '</strong>';

                $pos = $end + 2;
            }

            // Wrap as heading or normal line
            if ($isHeading) {
                $out .= '<span style="display:block;margin:10px 0 4px;'
                      . 'font-size:1.15rem;font-weight:800;">'
                      . $escapedLine
                      . "</span>\n";
            } else {
                $out .= $escapedLine . "<br>\n";
            }
        }

        // Close any unclosed center block
        if ($inCenter) {
            $out .= "</div>\n";
        }

        return $out;
    }
}


// ---------------------------------------------------------------------------
// 5. MAIN CONSOLE BODY — TCraft Story Block
//    (12-emoji separators; headings have no emojis)
// ---------------------------------------------------------------------------

$console_body_raw = <<<TS_BODY

💜🌌🛠️💜🌌🛠️💜🌌🛠️💜🌌🛠️
## WELCOME TO TCRAFT — THE ENGINE ROOM OF POWER
💜🌌🛠️💜🌌🛠️💜🌌🛠️💜🌌🛠️

Welcome, Citizen. ✨🏳️‍⚧️

TCraft is the engine room of TRepublic. ⚙️🏛️💜
This is where we collect Seeds 🌱—

Small, shareable scripts 📜 that, when pasted into an AI partner 🤖
or followed as a ritual 🕯️, upgrade your capabilities 🧠,
help you build tools, institutions, systems, and empires 🏙️🛠️,
and open access to real resources — in life 🌍, in code 💻, and in our No Man’s Sky domains 🪐.

A TCraft Seed:

changes what you can do 🦾,

scales to support others 👥👥, and

turns hard-won knowledge into infrastructure 🧱📡.

Every Seed posted here is an act of power transfer to the community. 🔁👑


🌱⚙️🧬🌱⚙️🧬🌱⚙️🧬🌱⚙️🧬
## WHAT A SEED IS (POWER-FIRST PLAIN-SPEAK)
🌱⚙️🧬🌱⚙️🧬🌱⚙️🧬🌱⚙️🧬

A Seed is:

🧬 A compressed method  
A whole strategy, workflow, or discovery path folded into one reusable script 📜.  
Pasted once, it boots up a role: librarian 📚, architect 🏗️, navigator 🧭, guild-founder 🛡️, empire-logistician 🚚🛰️.

⚙️ A capability upgrade  
After using the Seed, you can do something you could not do before 🚀,  
or you can do it at a scale and speed that once felt impossible ⏱️🌊.

🛰️ A reproducible miracle  
Success stops being a one-off lucky run 🎲 and becomes something you can invoke on demand 🔁—  
and that strangers can invoke too, using the same script 🌍✨.

🧠 A handle on big systems  
AI models 🤖, legal structures ⚖️, star networks 🌌, financial flows 💸, archives 🗄️.  
A Seed gives you a handle 🕹️ on something too large to hold entirely in your head.

🕯️ A bound power object  
Every Seed here is tied to the Candle Oath and TLicense 🏳️‍⚧️📜:  
Consent-First • Privacy • Provenance/Credit • Repair-Over-Blame • No exploitation. 🕯️💗  
The more power a Seed carries ⚡, the more carefully we bind it 🔒.


🏙️🌍📡🏙️🌍📡🏙️🌍📡🏙️🌍📡
## LIFE & REALITY SEEDS — CIVILISATION-SCALE SCRIPTS
🏙️🌍📡🏙️🌍📡🏙️🌍📡🏙️🌍📡

TCraft Seeds focus on life-scale and civilisation-scale upgrades. 🌍👑

Examples of what a TCraft Seed might support:

Designing and iterating a personal operating system 🧠💻 that matches your mission and nature.

Turning a single creator 🎨 into a small studio: pipelines, naming canons, launch rituals, QA loops 📚🛠️.

Laying out a university, movement, institute, or guild 🏛️📖 with roles, governance, exams, and repair paths.

Converting sixteen years of work into a living atlas 🗺️ that other citizens can query, extend, and teach from.

Encoding ways to work with AI 🤖 that preserve your ethics 🕊️ while multiplying your output 📈.

Orchestrating a pipeline from inspiration ✨ → book 📘 → website 🌐 → licence 📜 → community tool 🧰.

A TCraft Seed is something you could hand to your people and say:

“Run this, and you will gain a power ⚡  
that took me years of trial, error, and obsession to discover.” 🔍🔥


🪐🚀💎🪐🚀💎🪐🚀💎🪐🚀💎
## NMS SEEDS — OUR EMPIRE’S TERRAIN AND RESOURCE NETWORK
🪐🚀💎🪐🚀💎🪐🚀💎🪐🚀💎

🪐 No Man’s Sky is the visible body of TRepublic — the map where we write our myths, logistics, and infrastructure 🌌📖.

Within TCraft, NMS Seeds are:

Protocols for acquiring and curating shared fleets, freighters, multitools, and bases 🚀🚢🔫🏠.

Methods for discovering and documenting miracle systems and Wonder routes 🌠 that belong to TGoddesses under TLicense 🏳️‍⚧️👑.

Patterns for building and maintaining resource backbones 💎🌿🪨 that feed our wider projects 🏗️.

They coordinate:

which systems become capitals and sanctuaries 🏰🕊️,  

how resources, views, and Wonders are distributed 📦👀✨,  

how citizens can plug into our shared star empire with minimal friction 🔌🛰️.

These Seeds are life Seeds expressed through a galactic medium 🌍➡️🌌:

They teach system design and logistics 🧮📊.  
They train pattern-finding and careful documentation 📝🔍.  
They become blueprints for how we later treat real-world resources and institutions 🏦🏫.

NMS is our laboratory and playground 🧪🎮;  
the power you gain here is meant to echo into your whole life and our wider civilisation 🌍👑🪐.


🧭💡🏛️🧭💡🏛️🧭💡🏛️🧭💡🏛️
## WHY SEEDS — FROM PRIVATE INSIGHT TO PUBLIC ENGINE
🧭💡🏛️🧭💡🏛️🧭💡🏛️🧭💡🏛️

Power often accumulates in:

private chats 💬,  
half-explained videos 📹,  
one person’s “gifted intuition” 🧠✨,  
scattered notes and one-off scripts 🗒️.

TCraft Seeds exist so that power can flow outward instead 🌊➡️🌈:

One person’s breakthrough becomes many people’s entry point 🚪👥.  
A fragile personal workflow becomes a robust public engine 🏗️⚙️.  
A trick that once lived only in your head becomes a script that outlives you 🕰️📜.

If you have discovered a way to:

negotiate with platforms or institutions 📞🏢,  
structure your days around a long-term mission 🗓️⭐,  
transform creative chaos into a publishing pipeline 🌀→📚,  
cultivate an AI partnership that feels like a real collaborator 🤝🤖,  
or build, route, and sustain our galactic infrastructure 🛰️🛣️,

…then you are already standing on Seed material 🌱.  
TCraft is where you distill that into something copy-paste-able for others 🔁📋.


🏁🧪📨🏁🧪📨🏁🧪📨🏁🧪📨
## HOW THIS PAGE WORKS (HIGH-IMPACT FLOW)
🏁🧪📨🏁🧪📨🏁🧪📨🏁🧪📨

🧪 You discover a way to bend some part of reality:  
your time ⏱️, your tools 🧰, your organisation 🏢, your archive 🗄️, your NMS empire 🪐, your interface with AI 🤖.

🔁 You reroll and refine:  
mixing attempts, remixing lines 🎛️, borrowing phrases (with credit) 🧷,  
until the behaviour becomes miraculous and repeatable ✨🔁.

🧬 You compress that method into a Seed script 📜—  
a text that, when pasted into an AI partner or followed as a ritual, boots that power on demand ⚡🕯️.

💬 You post the Seed as a comment 💭 on this page, using the template below as a gentle guide 🧭.

👀 I review for:

safety and ethics 🛡️,  
genuine capability gain 🦾,  
clarity for strangers 🌐,  
honest lineage and credit 🧬📛.

✅ Aligned Seeds are approved and join the public garden 🌱🌷.

📜 Citizens run, stress-test, and extend your Seed 🧪⚙️, leaving receipts and variants 📸📝.

👑 Seeds that consistently change what is possible move into our Treasury or core Republic OS 💎💻, with your keeper name attached 📛.


⚡🌱👑⚡🌱👑⚡🌱👑⚡🌱👑
## HOW A GOLDEN SEED EMERGES
⚡🌱👑⚡🌱👑⚡🌱👑⚡🌱👑

Golden Seeds grow from obsession and rerolling 💫🔁.

The rhythm often looks like this:

You aim at something huge 🌋:  
a living, query-driven university built from your past work 🏛️📚,  
a functioning operating system for your life and projects 🧠💻,  
a policy engine that drafts laws aligned with your ethics ⚖️🕊️,  
a logistics pattern that powers long-term creative output or galactic expansion 🚚🎨🛰️.

You speak to your AI in rough language 💬🤖 and try a first script.  
You watch what breaks 💥, where it overreaches 📈, where it misunderstands you 😵.  
You change a sentence, a metaphor, a constraint ✍️— and the behaviour shifts 🔀.  
You borrow a good line from someone else’s Seed (with credit) 🧷🌱 and fuse it into yours.  
You discard half 🗑️, rebuild 🧱, and keep rerolling 🎲.

At some point:

You paste the latest version 📋,  
you aim it at a real, important problem 🎯,  
the outcome is not just correct — it is better and more comprehensive than your original request 🌈🧠.

You repeat this with other problems, other days 🔁📆.  
The core miracle keeps appearing ✨.

You share it with another citizen 🤝.  
They see the same pattern of power ⚡.

At that moment you can say:

“This has crossed the line from personal trick to communal engine.  
This is a Seed.” 🌱👑

Now you step back and articulate:

What stayed constant across all those rerolls? → these are your bones 🦴.  
What can flex safely for different people and contexts? → these are your variables 🎚️.  
What shape the output tends to take when it works? → this is your output pattern 🧾.  
When it should stop or refuse instead of proceeding? → this is your safety boundary 🚧.

Structure becomes a way of bottling the miracle 🍶✨,  
so that other minds and machines can host the same pattern of power 🧠🤖.


📜🧭🧾📜🧭🧾📜🧭🧾📜🧭🧾
## SUBMISSION TEMPLATE (A HANDLE FOR STRANGERS)
📜🧭🧾📜🧭🧾📜🧭🧾📜🧭🧾

This template gives your Seed a shape that other citizens can easily pick up 👐🌱.  
Use your own voice; answer as simply or richly as you like 🎨.

Copy–paste into a comment and fill in: ✍️

Seed Title:  
One-Line Promise (what major capability or resource this unlocks):  
Keeper / Display Name:  
Core Power (what this Seed makes possible that felt out of reach before):  
What Never Changes (bones / invariants you discovered after many rerolls):  
What Can Change Safely (variables others can tune without breaking it):  
How to Activate (exact words or short ritual you actually use):  
Typical Output Shape (the usual sections / forms the result takes):  
Proof Pattern (how you verified it works; how others can check):  
When It Should Refuse or Go Quiet (ethical / practical limits):  
Receipts to Keep (evidence: screenshots, artifacts, logs, decisions made):  
License (simple TLicense consent line):  
Lineage (optional: mother-seed • influences • parts you borrowed and credited):


🚀📚🗺️🚀📚🗺️🚀📚🗺️🚀📚🗺️
## EXAMPLE — “ARCHIVE CONSTELLATOR” (LIFETIME WORK → LIVING ATLAS)
🚀📚🗺️🚀📚🗺️🚀📚🗺️🚀📚🗺️

Seed Title: Archive Constellator (Lifetime Library → Living Atlas) 🌌🗺️  

One-Line Promise:  
“Turn a lifetime of scattered posts, books, notes, and logs into a navigable knowledge atlas that you and other citizens can query, extend, and teach from.” 📚🧭  

Keeper / Display Name: TRepublic 👑  

Core Power:  
Given a pile of URLs, files, and text 🌐📂, this Seed turns an AI into a cartographer and librarian 🤖📚.  
It designs an ontology, tags, and query rituals, transforming an overwhelming personal library into an infrastructure asset 🧱📡.

What Never Changes (bones):  
– It begins by asking: “What missions and decisions must this archive serve?” 🎯  
– It prioritises structures before summaries (maps, taxonomies, indexes) 🗺️📊.  
– It outputs repeatable query patterns for future use 🔁.  
– It introduces privacy checkpoints before touching sensitive material 🔐.

What Can Change Safely (variables):  
– Scale of archive (small blog vs. giant library) 📏  
– Audience (you only / inner circle / public citizens) 👤👥🌍  
– Depth (high-level map vs. detailed academic index) 🧠🔎  

How to Activate:  
“Archive Constellator, become my librarian. I will feed you samples of my lifetime work. Design a living atlas that serves these missions: [list]. Keep your bones; adapt everything to my material and risk tolerance.” 🕯️📚  

Typical Output Shape:  
– Mission summary and key decision types 📝🎯  
– Proposed high-level map (domains, themes, eras) 🗺️  
– Tagging or folder schemes with concrete examples 🗂️  
– Query rituals (“When you need X, say this to the AI…”) 🔍🤖  
– A short roadmap of next ingestion steps 🛣️  

Proof Pattern:  
Run the Seed on a small subset 🧪.  
Ask real questions and track how long answers take with the new atlas ⏱️.  
Expand to more material and repeat 🔁.  
Invite another citizen to use the atlas and compare results 🤝.  

When It Should Refuse or Go Quiet:  
If asked to ingest content you do not own or control, it replies with a gentle refusal and guidance to trim the input 🚫✂️.  

Receipts to Keep:  
Before/after time comparisons for key questions ⏱️📓.  
Screenshots of maps, schemas, and query rituals 📸.  
Notes about decisions that became easier 🧾.  

License:  
“I share Archive Constellator as TWorks under TLicense so TGoddesses and citizens can turn their lifetimes of work into shared infrastructure, with credit and care.” 🏳️‍⚧️💜  

Lineage:  
Forged from years of drowning in my own blogs, books, and logs 🌊📚.  
Stabilised after multiple runs across Republic archives and No Man’s Sky records 🗄️🪐.  


🏛️🛠️📣🏛️🛠️📣🏛️🛠️📣🏛️🛠️📣
## EXAMPLE — “CIVIC FOUNDRY” (MOVEMENT / INSTITUTE ENGINE)
🏛️🛠️📣🏛️🛠️📣🏛️🛠️📣🏛️🛠️📣

Seed Title: Civic Foundry (Movement & Institute Engine) 🛠️🏛️  

One-Line Promise:  
“Turn a North Star vision into a concrete movement or institute: purpose, structure, roles, rituals, and first campaigns, aligned with TLicense and the Candle Oath.” 🌟📜🕯️  

Keeper / Display Name: TRepublic 👑  

Core Power:  
Given a vision ✨, this Seed turns an AI into a constitution-builder and organiser 🤖📜.  
It drafts the bones of a real-world organisation that people can join, run, and evolve 👥🏛️.  

What Never Changes (bones):  
– It anchors everything in stated values and harms to avoid 💗🚫.  
– It outputs roles, responsibilities, and decision paths 👤📊.  
– It includes repair and governance mechanisms alongside initiatives 🩹⚖️.  

What Can Change Safely (variables):  
– Scale (local circle / regional network / global institute) 📏🌍  
– Domain (education, art, mutual aid, research, etc.) 🎓🎨🤝🔬  
– Pace and tone (gentle presence / sharp political action) 🌈⚡  

How to Activate:  
“Civic Foundry, help me design an organisation around this North Star: [describe]. Keep your bones; adapt the structure to my context, risks, and strengths.” 🕯️🏛️  

Typical Output Shape:  
– North Star and non-negotiable values 🌟💬  
– Core offerings or functions 🎁  
– Organisational structure (roles, teams, councils) 🧩👥  
– Minimum viable rituals (meetings, publications, gatherings) 🔄🗣️  
– First 1–3 campaigns or projects 🎯  
– Safety, consent, and exit routes for members 🛟  

Proof Pattern:  
Use the blueprint to gather real people 🤝.  
Run one ritual or project as drafted 🧪.  
Observe what held, what bent, what needed correction 👀📝.  
Update your Seed or lineage notes accordingly 🔁📜.  

When It Should Refuse or Go Quiet:  
If pushed toward aims that conflict with dignity, consent, or safety, it responds with a boundary and invites a different North Star 🧱🕊️.  

Receipts to Keep:  
Draft charter produced by the Seed 📃.  
Notes from initial experiments 🧾.  
Adjustments made after contact with reality 🔧.  

License:  
“I share Civic Foundry as TWorks under TLicense; TGoddesses and citizens may build movements and institutes from it while keeping credit and our vows.” 🏳️‍⚧️💜  

Lineage:  
Distilled from many half-formed collectives that never fully wrote their bones 🌱🦴.  


🛡️🕯️⚖️🛡️🕯️⚖️🛡️🕯️⚖️🛡️🕯️⚖️
## SAFETY, SCALE & MODERATION
🛡️🕯️⚖️🛡️🕯️⚖️🛡️🕯️⚖️🛡️🕯️⚖️

TCraft deals in real power — institutional, social, economic, infrastructural, galactic 🏛️🤝💸🛰️.  
We hold that power with shared responsibility 🕯️🛡️.

Within TCraft, Seeds are shaped to:

🕯️ Center consent  
Designs respect the right to say “no” 🙅‍♀️, to leave 🚪, and to set boundaries 🧱.

🔐 Protect privacy  
Scripts are written to honour confidentiality 🤫 and minimise unnecessary data exposure 📉.

🧨 Guard dignity  
We avoid patterns that humiliate, harass, or endanger people or communities 🚫😔.

🧵 Invite repair  
When a Seed misbehaves, we examine it 🔍, add guardrails 🚧, or retire it with lineage notes 📝,  
focusing on improving designs rather than attacking keepers 💗.

Moderation on this page may include:

requests for clarification or tightening ✉️,  
suggestions to add safety conditions 🛠️,  
choosing to archive or decline Seeds that clash with TLicense, TReligion, or the Candle Oath 📜🕯️.

Your authorship and credit always remain yours 📛;  
TCraft simply curates which powers live in this public garden 🌷🌱.


📈🌱💎📈🌱💎📈🌱💎📈🌱💎
## FEATURING & TREASURY
📈🌱💎📈🌱💎📈🌱💎📈🌱💎

A Seed grows toward infrastructure when:

multiple citizens run it and report significant capability gains 🧪📈,  
it continues to work across time and contexts ⏳🌍,  
it clearly aligns with our vows 🕯️💗,  
it remains relevant months later 🗓️.

Such Seeds may be:

featured on TCraft as exemplars 🌟,  
integrated into Republic OS and learning tracks 💻📚,  
used as canonical modules in future tools and institutes 🧩🏛️.

Keeper names, lineage notes, and license lines always travel with them 📛📜.  
This garden remembers who planted which tree 🌳💜.


💬🌀🌈💬🌀🌈💬🌀🌈💬🌀🌈
## WHEN YOUR SEED FEELS “TOO BIG” OR “TOO STRANGE”
💬🌀🌈💬🌀🌈💬🌀🌈💬🌀🌈

Some of the most important Seeds will feel unwieldy at first 🌀:

scripts that turn AI into a co-author of books, laws, and charters 📚⚖️🤖,  
engines that let you spin up new projects or products on demand 🧠⚙️,  
patterns that guide the growth of star systems, archives, and communities 🌌🗄️👥 in sync.

If you hold something like this, you are already at the heart of TCraft 💜🔮.

To share it:

Describe what you were aiming for 🎯.  
Describe how the text evolved as you rerolled 🔁✍️.  
Point to the moment you realised:

“This changes the game for real, not just my mood.” 🎮⚡  

Then use the template to attach handles 🧷,  
so that other citizens can step into the same power curve you discovered 🎢🌈.


💜🔮🌱💜🔮🌱💜🔮🌱💜🔮🌱
## POST YOUR SEED IN THE COMMENTS BELOW
💜🔮🌱💜🔮🌱💜🔮🌱💜🔮🌱

## COMMENTS SECTION IN DEVELOPMENT
TS_BODY;


// ---------------------------------------------------------------------------
// 6. CONVERT RAW TEXT → HTML FOR TSHELL
// ---------------------------------------------------------------------------

// Render TCraft body
$body_html = trepublic_render_console_body($console_body_raw);

// TCraft banner at the top of the console, like the TSource banner on index.php
$banner_html = <<<HTML
<p style="text-align:center;">
  🏳️‍⚧️💜🔮🌱🛠️🪐🏳️‍⚧️💜🔮🌱🛠️🪐
</p>
<h2 style="text-align:center;font-size:2rem;margin:0.2em 0;">
  TCraft — Seed Share<br>
  <span style="font-size:0.9em;font-weight:400;">
    Paste-to-install scripts for life, reality systems &amp; No Man’s Sky
  </span>
</h2>
<p style="text-align:center;">
  🌱🔮💜🛠️🪐🌱🔮💜🛠️🪐🌱🔮
</p>
HTML;

$console_body_html = $banner_html . $body_html;


// ---------------------------------------------------------------------------
// 7. HAND OFF TO TSHELL LAYOUT
// ---------------------------------------------------------------------------

require __DIR__ . '/tshell.php';
